/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6985")
public class TorchLoadLeadsToUntrustedCodeExecutionCheck
extends PythonSubscriptionCheck {
    public static final String TORCH_LOAD = "torch.load";
    public static final String MESSAGE = "Replace this call with a safe alternative.";
    public static final String PYTHON_FALSE = "False";
    public static final String WEIGHTS_ONLY = "weights_only";
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(ctx.pythonFile());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol != null && TORCH_LOAD.equals(calleeSymbol.fullyQualifiedName()) && this.isWeightsOnlyNotFoundOrSetToFalse(callExpression.arguments())) {
                ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
            }
        });
    }

    private boolean isWeightsOnlyNotFoundOrSetToFalse(List<Argument> arguments) {
        RegularArgument weightsOnlyArg = TreeUtils.argumentByKeyword((String)WEIGHTS_ONLY, arguments);
        if (weightsOnlyArg == null) {
            return !Expressions.containsSpreadOperator(arguments);
        }
        Expression expression = weightsOnlyArg.expression();
        if (expression instanceof Name) {
            Name name = (Name)expression;
            return PYTHON_FALSE.equals(name.name()) || this.isNameSetToFalse(name);
        }
        return false;
    }

    private boolean isNameSetToFalse(Name name) {
        Set values = this.reachingDefinitionsAnalysis.valuesAtLocation(name);
        return values.size() == 1 && values.stream().flatMap(TreeUtils.toStreamInstanceOfMapper(Name.class)).map(Name::name).allMatch(PYTHON_FALSE::equals);
    }
}

