/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

public class GraphQLUtils {
    private static final Set<String> GRAPHQL_VIEWS_FQNS = Set.of("flask_graphql.GraphQLView", "graphql_server.flask.GraphQLView");
    private static final String AS_VIEW_CALLEE_NAME = "as_view";

    private GraphQLUtils() {
    }

    public static boolean isOrExtendsGraphQLView(Symbol symbol) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS})) {
            return GRAPHQL_VIEWS_FQNS.stream().anyMatch(arg_0 -> ((ClassSymbol)((ClassSymbol)symbol)).isOrExtends(arg_0));
        }
        return Optional.of(symbol).map(Symbol::fullyQualifiedName).filter(GRAPHQL_VIEWS_FQNS::contains).isPresent();
    }

    public static boolean isCallToAsView(QualifiedExpression qualifiedExpression) {
        return Optional.of(qualifiedExpression).map(QualifiedExpression::name).map(Name::name).filter(AS_VIEW_CALLEE_NAME::equals).isPresent();
    }

    public static boolean expressionTypeOrNameMatchPredicate(Expression expression, Predicate<String> predicate) {
        Stream<Optional> expressionNameAndType = Stream.of(TreeUtils.nameFromQualifiedOrCallExpression((Expression)expression), Optional.ofNullable(InferredTypes.typeName((InferredType)expression.type())));
        return expressionNameAndType.filter(Optional::isPresent).map(Optional::get).anyMatch(predicate);
    }

    public static boolean expressionFQNMatchPredicate(Expression expression, Predicate<String> predicate) {
        return TreeUtils.getSymbolFromTree((Tree)expression).map(Symbol::fullyQualifiedName).filter(predicate).isPresent();
    }
}

