/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.python.checks.cdk.AbstractIamPolicyStatementCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6270")
public class IamPolicyPublicAccessCheck
extends AbstractIamPolicyStatementCheck {
    private static final String ISSUE_MESSAGE = "Make sure granting public access is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect.";

    @Override
    protected void checkAllowingPolicyStatement(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow principals = policyStatement.principals();
        if (principals == null) {
            return;
        }
        CdkUtils.getListExpression(principals).map(list -> CdkUtils.getListElements(principals.ctx(), list)).orElse(Collections.emptyList()).forEach(principalElement -> IamPolicyPublicAccessCheck.raiseIssueIf(principalElement, IamPolicyPublicAccessCheck.isSensitivePrincipal(), policyStatement.effect()));
    }

    @Override
    protected void checkPolicyStatementFromJson(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow effect = policyStatement.effect();
        CdkUtils.ExpressionFlow principals = policyStatement.principals();
        if (principals == null || !IamPolicyPublicAccessCheck.hasAllowEffect(effect)) {
            return;
        }
        IamPolicyPublicAccessCheck.raiseIssueIf(principals, CdkPredicate.isWildcard(), effect);
        CdkUtils.getDictionary(principals).flatMap(innerDict -> CdkUtils.getDictionaryPair(principals.ctx(), innerDict, "AWS")).map(aws -> IamPolicyPublicAccessCheck.getSensitiveExpression(aws.value, CdkPredicate.isWildcard())).ifPresent(sensitiveAwsPrincipal -> IamPolicyPublicAccessCheck.raiseIssueIf(sensitiveAwsPrincipal, CdkPredicate.isWildcard(), effect));
    }

    private static Predicate<Expression> isSensitivePrincipal() {
        return CdkPredicate.isFqnOf(List.of("aws_cdk.aws_iam.StarPrincipal", "aws_cdk.aws_iam.AnyPrincipal")).or(IamPolicyPublicAccessCheck.isSensitiveArnPrincipal());
    }

    private static Predicate<Expression> isSensitiveArnPrincipal() {
        return expression -> CdkUtils.getCall(expression, "aws_cdk.aws_iam.ArnPrincipal").map(callExpression -> TreeUtils.nthArgumentOrKeyword((int)0, (String)"arn", (List)callExpression.arguments())).map(RegularArgument::expression).filter(CdkPredicate.isWildcard()).isPresent();
    }

    private static void raiseIssueIf(CdkUtils.ExpressionFlow expressionFlow, Predicate<Expression> predicate, @Nullable CdkUtils.ExpressionFlow effect) {
        if (effect != null) {
            expressionFlow.addIssueIf(predicate, ISSUE_MESSAGE, effect.asSecondaryLocation(SECONDARY_MESSAGE));
        } else {
            expressionFlow.addIssueIf(predicate, ISSUE_MESSAGE, new IssueLocation[0]);
        }
    }
}

