/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S5905")
public class AssertOnTupleLiteralCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Fix this assertion on a tuple literal.";
    public static final String QUICK_FIX_MESSAGE = "Remove parentheses";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSERT_STMT, ctx -> {
            AssertStatement assertStatement = (AssertStatement)ctx.syntaxNode();
            if (assertStatement.condition().is(new Tree.Kind[]{Tree.Kind.TUPLE}) && assertStatement.message() == null) {
                Tuple tuple = (Tuple)assertStatement.condition();
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)tuple, MESSAGE);
                if (tuple.leftParenthesis() != null && tuple.rightParenthesis() != null) {
                    issue.addQuickFix(PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.remove((Tree)tuple.leftParenthesis())}).addTextEdit(new PythonTextEdit[]{TextEditUtils.remove((Tree)tuple.rightParenthesis())}).build());
                }
            }
        });
    }

    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }
}

