/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.InferredTypes;

public abstract class IncompatibleOperands
extends PythonSubscriptionCheck {
    private static final Map<String, String> UNARY_SPECIAL_METHODS_BY_OPERATOR = new HashMap<String, String>();
    private static final Map<String, SpecialMethodNames> BINARY_SPECIAL_METHODS_BY_OPERATOR;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> ctx.syntaxNode().accept((TreeVisitor)new IncompatibleOperandsVisitor((SubscriptionContext)ctx)));
    }

    private static boolean hasIncompatibleTypeOrAbsentSpecialMethod(@Nullable Symbol resolvedMethod, InferredType type) {
        List parameters;
        if (resolvedMethod == null) {
            return true;
        }
        if (resolvedMethod.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) && (parameters = ((FunctionSymbol)resolvedMethod).parameters()).size() == 2) {
            InferredType parameterType = ((FunctionSymbol.Parameter)parameters.get(1)).declaredType();
            return !type.isCompatibleWith(parameterType);
        }
        if (resolvedMethod.is(new Symbol.Kind[]{Symbol.Kind.AMBIGUOUS})) {
            return ((AmbiguousSymbol)resolvedMethod).alternatives().stream().allMatch(s -> IncompatibleOperands.hasIncompatibleTypeOrAbsentSpecialMethod(s, type));
        }
        return false;
    }

    public abstract SpecialMethod resolveMethod(InferredType var1, String var2);

    public abstract String message(Token var1, InferredType var2, InferredType var3);

    public abstract String message(Token var1);

    static {
        UNARY_SPECIAL_METHODS_BY_OPERATOR.put("+", "__pos__");
        UNARY_SPECIAL_METHODS_BY_OPERATOR.put("-", "__neg__");
        UNARY_SPECIAL_METHODS_BY_OPERATOR.put("~", "__invert__");
        BINARY_SPECIAL_METHODS_BY_OPERATOR = new HashMap<String, SpecialMethodNames>();
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("<", new SpecialMethodNames("__lt__", "__gt__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("<=", new SpecialMethodNames("__le__", "__ge__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put(">", new SpecialMethodNames("__gt__", "__lt__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put(">=", new SpecialMethodNames("__ge__", "__le__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("+", new SpecialMethodNames("__add__", "__radd__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("-", new SpecialMethodNames("__sub__", "__rsub__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("*", new SpecialMethodNames("__mul__", "__rmul__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("@", new SpecialMethodNames("__matmul__", "__rmatmul__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("/", new SpecialMethodNames("__truediv__", "__rtruediv__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("//", new SpecialMethodNames("__floordiv__", "__rfloordiv__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("%", new SpecialMethodNames("__mod__", "__rmod__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("**", new SpecialMethodNames("__pow__", "__rpow__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("<<", new SpecialMethodNames("__lshift__", "__rlshift__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put(">>", new SpecialMethodNames("__rshift__", "__rrshift__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("&", new SpecialMethodNames("__and__", "__rand__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("^", new SpecialMethodNames("__xor__", "__rxor__"));
        BINARY_SPECIAL_METHODS_BY_OPERATOR.put("|", new SpecialMethodNames("__or__", "__ror__"));
    }

    protected static class SpecialMethod {
        @Nullable
        protected final Symbol symbol;
        private final boolean isUnresolved;

        public SpecialMethod(@Nullable Symbol symbol, boolean isUnresolved) {
            this.symbol = symbol;
            this.isUnresolved = isUnresolved;
        }

        boolean isAbsent() {
            return this.symbol == null && !this.isUnresolved;
        }
    }

    private class IncompatibleOperandsVisitor
    extends BaseTreeVisitor {
        private final SubscriptionContext context;

        IncompatibleOperandsVisitor(SubscriptionContext context) {
            this.context = context;
        }

        public void visitTypeAnnotation(TypeAnnotation tree) {
        }

        public void visitBinaryExpression(BinaryExpression binaryExpression) {
            InferredType leftType = binaryExpression.leftOperand().type();
            InferredType rightType = binaryExpression.rightOperand().type();
            this.checkOperands(binaryExpression.operator(), leftType, rightType);
            super.visitBinaryExpression(binaryExpression);
        }

        public void visitUnaryExpression(UnaryExpression unaryExpression) {
            InferredType type = unaryExpression.expression().type();
            Token operator = unaryExpression.operator();
            String memberName = UNARY_SPECIAL_METHODS_BY_OPERATOR.get(operator.value());
            if (memberName != null && IncompatibleOperands.this.resolveMethod(type, memberName).isAbsent()) {
                this.context.addIssue(operator, IncompatibleOperands.this.message(operator));
            }
            super.visitUnaryExpression(unaryExpression);
        }

        private void checkOperands(Token operator, InferredType left, InferredType right) {
            if (InferredTypes.typeSymbols((InferredType)left).stream().anyMatch(ClassSymbol::hasDecorators) || InferredTypes.typeSymbols((InferredType)right).stream().anyMatch(ClassSymbol::hasDecorators)) {
                return;
            }
            SpecialMethodNames specialMethodNames = BINARY_SPECIAL_METHODS_BY_OPERATOR.get(operator.value());
            if (specialMethodNames == null) {
                return;
            }
            SpecialMethod leftSpecialMethod = IncompatibleOperands.this.resolveMethod(left, specialMethodNames.left);
            SpecialMethod rightSpecialMethod = IncompatibleOperands.this.resolveMethod(right, specialMethodNames.right);
            if (leftSpecialMethod.isAbsent() && rightSpecialMethod.isAbsent()) {
                this.context.addIssue(operator, IncompatibleOperands.this.message(operator, left, right));
                return;
            }
            if (leftSpecialMethod.isUnresolved || rightSpecialMethod.isUnresolved) {
                return;
            }
            boolean hasIncompatibleLeftSpecialMethod = IncompatibleOperands.hasIncompatibleTypeOrAbsentSpecialMethod(leftSpecialMethod.symbol, right);
            boolean hasIncompatibleRightSpecialMethod = IncompatibleOperands.hasIncompatibleTypeOrAbsentSpecialMethod(rightSpecialMethod.symbol, left);
            if (hasIncompatibleLeftSpecialMethod && hasIncompatibleRightSpecialMethod) {
                this.context.addIssue(operator, IncompatibleOperands.this.message(operator, left, right));
            }
        }
    }

    private static class SpecialMethodNames {
        private final String left;
        private final String right;

        public SpecialMethodNames(String left, String right) {
            this.left = left;
            this.right = right;
        }
    }
}

