/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractIamPolicyStatementCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractIamPolicyStatementCheck {
    private static final Logger LOG = Loggers.get(ResourceAccessPolicyCheck.class);
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";
    String resourceNameSensitiveAwsActions = "ResourceAccessPolicyCheck.txt";
    private Set<String> sensitiveAwsActions = null;

    void init() {
        try {
            this.sensitiveAwsActions = new HashSet<String>(ResourceAccessPolicyCheck.loadResource(this.resourceNameSensitiveAwsActions));
        }
        catch (IOException e) {
            this.sensitiveAwsActions = Collections.emptySet();
            LOG.error("Couldn't load resource '" + this.resourceNameSensitiveAwsActions + "', rule [S6304] ResourceAccessPolicyCheck will be disabled.", (Throwable)e);
        }
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        super.initialize(context);
        this.init();
    }

    /*
     * Exception decompiling
     */
    private static List<String> loadResource(String resourceName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void checkAllowingPolicyStatement(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow actions = policyStatement.actions();
        CdkUtils.ExpressionFlow resources = policyStatement.resources();
        if (resources == null || actions == null || !this.isSensitiveAction(actions)) {
            return;
        }
        Optional.ofNullable(ResourceAccessPolicyCheck.getSensitiveExpression(resources, CdkPredicate.isWildcard())).ifPresent(wildcard -> ResourceAccessPolicyCheck.reportWildcardResourceAndEffect(wildcard, policyStatement.effect()));
    }

    private boolean isSensitiveAction(CdkUtils.ExpressionFlow actions) {
        return ResourceAccessPolicyCheck.getSensitiveExpression(actions, this.inSensitiveSet()) != null;
    }

    public Predicate<Expression> inSensitiveSet() {
        return expression -> CdkUtils.getString(expression).filter(this.sensitiveAwsActions::contains).isPresent();
    }

    private static void reportWildcardResourceAndEffect(CdkUtils.ExpressionFlow wildcard, @Nullable CdkUtils.ExpressionFlow effect) {
        PythonCheck.PreciseIssue issue = wildcard.ctx().addIssue((Tree)wildcard.getLast(), MESSAGE);
        if (effect != null) {
            issue.secondary(effect.asSecondaryLocation(SECONDARY_MESSAGE));
        }
    }
}

