/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S5709")
public class ExceptionSuperClassDeclarationCheck
extends PythonSubscriptionCheck {
    private static final Set<String> FORBIDDEN_SUPER_CLASS_FQNS = new HashSet<String>(Arrays.asList("BaseException", "GeneratorExit", "KeyboardInterrupt", "SystemExit"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            ArgList args = classDef.args();
            if (args != null) {
                args.arguments().stream().filter(RegularArgument.class::isInstance).map(RegularArgument.class::cast).forEach(arg -> ExceptionSuperClassDeclarationCheck.checkSuperClass(arg, ctx));
            }
        });
    }

    private static void checkSuperClass(RegularArgument arg, SubscriptionContext ctx) {
        Symbol symbol;
        Expression expression = arg.expression();
        if (expression instanceof HasSymbol && (symbol = ((HasSymbol)expression).symbol()) != null && FORBIDDEN_SUPER_CLASS_FQNS.contains(symbol.fullyQualifiedName())) {
            ctx.addIssue((Tree)arg, String.format("Derive this class from \"Exception\" instead of \"%s\".", symbol.fullyQualifiedName()));
        }
    }
}

