/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;

@Rule(key="S6662")
public class HashMethodCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure this expression is hashable.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_LITERAL, ctx -> ((SetLiteral)ctx.syntaxNode()).elements().forEach(elem -> HashMethodCheck.checkHashMethod(elem, ctx)));
        context.registerSyntaxNodeConsumer(Tree.Kind.KEY_VALUE_PAIR, ctx -> HashMethodCheck.checkHashMethod(((KeyValuePair)ctx.syntaxNode()).key(), ctx));
    }

    private static void checkHashMethod(Expression expression, SubscriptionContext ctx) {
        InferredType type = expression.type();
        boolean hashIsManuallySetToNone = type.resolveMember("__hash__").filter(symbol -> ((SymbolImpl)symbol).inferredType().canOnlyBe("NoneType")).isPresent();
        if (hashIsManuallySetToNone) {
            ctx.addIssue((Tree)expression, MESSAGE);
        }
    }
}

