/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

public abstract class AbstractCallExpressionCheck
extends PythonSubscriptionCheck {
    protected abstract Set<String> functionsToCheck();

    protected abstract String message();

    protected boolean isException(CallExpression callExpression) {
        return false;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::visitNode);
    }

    public void visitNode(SubscriptionContext ctx) {
        CallExpression node = (CallExpression)ctx.syntaxNode();
        Symbol symbol = node.calleeSymbol();
        if (!this.isException(node) && symbol != null && this.functionsToCheck().contains(symbol.fullyQualifiedName())) {
            ctx.addIssue((Tree)node.callee(), this.message());
        }
    }

    protected static boolean isWithinImport(Tree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.IMPORT_NAME}) && !parent.is(new Tree.Kind[]{Tree.Kind.IMPORT_FROM})) continue;
            return true;
        }
        return false;
    }

    protected static <T> Set<T> immutableSet(T ... args) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(args)));
    }
}

