/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.TypeShed;

@Rule(key="S5806")
public class BuiltinShadowingAssignmentCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Rename this variable; it shadows a builtin.";
    public static final String REPEATED_VAR_MESSAGE = "Variable also assigned here.";
    public static final String RENAME_PREFIX = "_";
    public static final String QUICK_FIX_MESSAGE_FORMAT = "Rename to _ %s";
    private final Map<Symbol, PythonCheck.PreciseIssue> variableIssuesRaised = new HashMap<Symbol, PythonCheck.PreciseIssue>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.variableIssuesRaised.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, this::checkAnnotatedAssignment);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_EXPRESSION, this::checkAssignmentExpression);
    }

    private void checkAssignmentExpression(SubscriptionContext ctx) {
        AssignmentExpression assignmentExpression = (AssignmentExpression)ctx.syntaxNode();
        Name lhsName = assignmentExpression.lhsName();
        if (this.shouldReportIssue((Tree)lhsName)) {
            this.raiseIssueForNonGlobalVariable(ctx, lhsName);
        }
    }

    private void checkAssignment(SubscriptionContext ctx) {
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        Tree ancestor = TreeUtils.firstAncestorOfKind((Tree)assignment, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF});
        if (ancestor == null || ancestor.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            for (int i = 0; i < assignment.lhsExpressions().size(); ++i) {
                for (Expression expression : ((ExpressionList)assignment.lhsExpressions().get(i)).expressions()) {
                    if (!this.shouldReportIssue((Tree)expression)) continue;
                    this.raiseIssueForNonGlobalVariable(ctx, (Name)expression);
                }
            }
        }
    }

    private void checkAnnotatedAssignment(SubscriptionContext ctx) {
        AnnotatedAssignment assignment = (AnnotatedAssignment)ctx.syntaxNode();
        Tree ancestor = TreeUtils.firstAncestorOfKind((Tree)assignment, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF});
        if (ancestor == null || ancestor.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
            Expression variable = assignment.variable();
            Token equalToken = assignment.equalToken();
            if (equalToken != null && this.shouldReportIssue((Tree)variable)) {
                this.raiseIssueForNonGlobalVariable(ctx, (Name)variable);
            }
        }
    }

    private static Set<String> collectUsedNames(Tree tree) {
        return Optional.ofNullable(TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF})).map(FunctionLike.class::cast).map(BuiltinShadowingAssignmentCheck::collectFunctionVariableNames).stream().flatMap(Function.identity()).collect(Collectors.toSet());
    }

    private static Stream<String> collectFunctionVariableNames(FunctionLike funcDef) {
        return Stream.concat(funcDef.localVariables().stream().map(Symbol::name), Optional.of(funcDef).map(FunctionLike::parameters).map(ParameterList::all).stream().flatMap(Collection::stream).map(BuiltinShadowingAssignmentCheck::collectParameterNames).flatMap(Collection::stream));
    }

    private static Set<String> collectParameterNames(AnyParameter parameter) {
        HashSet<String> result = new HashSet<String>();
        Optional.of(parameter).filter(Parameter.class::isInstance).map(Parameter.class::cast).map(Parameter::name).map(Name::name).ifPresent(result::add);
        Optional.of(parameter).filter(TupleParameter.class::isInstance).map(TupleParameter.class::cast).map(TupleParameter::parameters).stream().flatMap(Collection::stream).map(BuiltinShadowingAssignmentCheck::collectParameterNames).forEach(result::addAll);
        return result;
    }

    private void raiseIssueForNonGlobalVariable(SubscriptionContext ctx, Name variable) {
        Optional.ofNullable(variable.symbol()).filter(symbol -> symbol.usages().stream().map(Usage::kind).noneMatch(arg_0 -> Usage.Kind.GLOBAL_DECLARATION.equals(arg_0))).ifPresent(symbol -> {
            PythonCheck.PreciseIssue existingIssue = this.variableIssuesRaised.get(symbol);
            if (existingIssue != null) {
                existingIssue.secondary((Tree)variable, REPEATED_VAR_MESSAGE);
            } else {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)variable, MESSAGE);
                this.variableIssuesRaised.put((Symbol)symbol, issue);
                Set<String> names = BuiltinShadowingAssignmentCheck.collectUsedNames((Tree)variable);
                if (!names.contains(RENAME_PREFIX + variable.name())) {
                    PythonQuickFix quickFix = BuiltinShadowingAssignmentCheck.createQuickFix(symbol);
                    issue.addQuickFix(quickFix);
                }
            }
        });
    }

    private static PythonQuickFix createQuickFix(Symbol symbol) {
        List edits = symbol.usages().stream().map(Usage::tree).map(Tree::firstToken).map(token -> TextEditUtils.insertBefore((Tree)token, (String)RENAME_PREFIX)).collect(Collectors.toList());
        return PythonQuickFix.newQuickFix((String)String.format(QUICK_FIX_MESSAGE_FORMAT, symbol.name())).addTextEdit(edits).build();
    }

    private boolean shouldReportIssue(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NAME}) && this.isBuiltInName((Name)tree) && TreeUtils.firstAncestorOfKind((Tree)tree.parent(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF}) != null;
    }

    private boolean isBuiltInName(Name name) {
        return TypeShed.builtinSymbols().containsKey(name.name());
    }
}

