/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5708")
public class CaughtExceptionsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this expression to be a class deriving from BaseException or a tuple of such classes.";
    private static final Set<String> NON_COMPLIANT_TYPES = new HashSet<String>(Arrays.asList("list", "set", "dict"));
    public static final String QUICK_FIX_MESSAGE_FORMAT = "Make \"%s\" deriving from \"Exception\"";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, CaughtExceptionsCheck::checkExceptClause);
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_GROUP_CLAUSE, CaughtExceptionsCheck::checkExceptClause);
    }

    private static void checkExceptClause(SubscriptionContext ctx) {
        Expression exception = ((ExceptClause)ctx.syntaxNode()).exception();
        if (exception == null) {
            return;
        }
        TreeUtils.flattenTuples((Expression)exception).forEach(expression -> {
            Optional expressionSymbolOpt = TreeUtils.getSymbolFromTree((Tree)expression);
            boolean notInheritsFromBaseException = expressionSymbolOpt.filter(Predicate.not(CaughtExceptionsCheck::inheritsFromBaseException)).isPresent();
            if (!CaughtExceptionsCheck.canBeOrExtendBaseException(expression.type()) || notInheritsFromBaseException) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)expression, MESSAGE);
                expressionSymbolOpt.ifPresent(symbol -> CaughtExceptionsCheck.addQuickFix(issue, symbol));
            }
        });
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Symbol symbol) {
        symbol.usages().stream().filter(Usage::isBindingUsage).findFirst().map(Usage::tree).map(Tree::parent).map(TreeUtils.toInstanceOfMapper(ClassDef.class)).ifPresent(classDef -> {
            Name insertAfter = classDef.name();
            String insertingText = "(Exception)";
            Token leftPar = classDef.leftPar();
            if (leftPar != null) {
                ArgList args = classDef.args();
                if (args == null) {
                    insertAfter = leftPar;
                    insertingText = "Exception";
                } else {
                    insertAfter = args;
                    insertingText = ", Exception";
                }
            }
            issue.addQuickFix(PythonQuickFix.newQuickFix((String)String.format(QUICK_FIX_MESSAGE_FORMAT, classDef.name().name())).addTextEdit(new PythonTextEdit[]{TextEditUtils.insertAfter((Tree)insertAfter, (String)insertingText)}).build());
        });
    }

    private static boolean canBeOrExtendBaseException(InferredType type) {
        if (NON_COMPLIANT_TYPES.stream().anyMatch(arg_0 -> ((InferredType)type).canOnlyBe(arg_0))) {
            return false;
        }
        if (type.canBeOrExtend("tuple")) {
            return true;
        }
        return type.canBeOrExtend("BaseException");
    }

    private static boolean inheritsFromBaseException(@Nullable Symbol symbol) {
        if (symbol == null || symbol.kind() != Symbol.Kind.CLASS) {
            return true;
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.canBeOrExtend("BaseException");
    }
}

