/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5685")
public class ConfusingWalrusCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use an assignment statement (\"=\") instead; \":=\" operator is confusing in this context.";
    private static final String MOVE_MESSAGE = "Move this assignment out of the %s; \":=\" operator is confusing in this context.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_EXPRESSION, ConfusingWalrusCheck::checkAssignmentExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, ctx -> {
            StringElement stringElement = (StringElement)ctx.syntaxNode();
            for (FormattedExpression formattedExpression : stringElement.formattedExpressions()) {
                ConfusingWalrusCheck.checkNestedWalrus(ctx, (Tree)formattedExpression.expression(), String.format(MOVE_MESSAGE, "interpolated expression"));
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER, ctx -> {
            Parameter parameter = (Parameter)ctx.syntaxNode();
            ConfusingWalrusCheck.checkNestedWalrus(ctx, (Tree)parameter, String.format(MOVE_MESSAGE, "function definition"));
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.ARG_LIST, ctx -> {
            ArgList argList = (ArgList)ctx.syntaxNode();
            if (ConfusingWalrusCheck.hasKeywordArguments(argList)) {
                ConfusingWalrusCheck.checkNestedWalrus(ctx, (Tree)argList, String.format(MOVE_MESSAGE, "argument list"));
            }
        });
    }

    private static void checkNestedWalrus(SubscriptionContext ctx, Tree tree, String message) {
        WalrusVisitor walrusVisitor = new WalrusVisitor();
        tree.accept((TreeVisitor)walrusVisitor);
        if (!walrusVisitor.assignmentExpressions.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(walrusVisitor.assignmentExpressions.get(0), message);
            walrusVisitor.assignmentExpressions.stream().skip(1L).forEach(a -> issue.secondary(a, null));
        }
    }

    private static void checkAssignmentExpression(SubscriptionContext ctx) {
        AssignmentExpression assignmentExpression = (AssignmentExpression)ctx.syntaxNode();
        Optional<Tree> parentTree = Optional.ofNullable(TreeUtils.firstAncestor((Tree)assignmentExpression, a -> !a.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})));
        parentTree.ifPresent(parent -> {
            if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
                ctx.addIssue((Tree)assignmentExpression, MESSAGE);
            }
            if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT})) {
                ctx.addIssue((Tree)assignmentExpression, MESSAGE);
            }
        });
    }

    private static boolean hasKeywordArguments(ArgList argList) {
        for (Argument argument : argList.arguments()) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT}) || ((RegularArgument)argument).keywordArgument() == null) continue;
            return true;
        }
        return false;
    }

    private static class WalrusVisitor
    extends BaseTreeVisitor {
        List<Tree> assignmentExpressions = new ArrayList<Tree>();

        private WalrusVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
            this.assignmentExpressions.add((Tree)assignmentExpression);
        }
    }
}

