/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.checks.Expressions;

@Rule(key="S3801")
public class ConsistentReturnCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Refactor this function to use \"return\" consistently.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null || ConsistentReturnCheck.hasExceptOrFinally(cfg)) {
                return;
            }
            List<Tree> endStatements = cfg.end().predecessors().stream().map(block -> ConsistentReturnCheck.parentStatement((Tree)block.elements().get(block.elements().size() - 1))).filter(s -> !s.is(new Tree.Kind[]{Tree.Kind.RAISE_STMT, Tree.Kind.ASSERT_STMT, Tree.Kind.WITH_STMT}) && !ConsistentReturnCheck.isWhileTrue(s)).collect(Collectors.toList());
            List returnsWithValue = endStatements.stream().filter(s -> s.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT}) && ConsistentReturnCheck.hasValue((ReturnStatement)s)).collect(Collectors.toList());
            if (returnsWithValue.size() != endStatements.size() && !returnsWithValue.isEmpty()) {
                ConsistentReturnCheck.addIssue(ctx, functionDef, endStatements);
            }
        });
    }

    private static boolean hasExceptOrFinally(ControlFlowGraph cfg) {
        return cfg.blocks().stream().anyMatch(block -> block instanceof CfgBranchingBlock && ((CfgBranchingBlock)block).branchingTree().is(new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.FINALLY_CLAUSE}));
    }

    private static boolean isWhileTrue(Statement statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.WHILE_STMT}) && Expressions.isTruthy(((WhileStatement)statement).condition());
    }

    private static void addIssue(SubscriptionContext ctx, FunctionDef functionDef, List<Tree> endStatements) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)functionDef.name(), MESSAGE);
        for (Tree statement : endStatements) {
            if (statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT})) {
                ReturnStatement returnStatement = (ReturnStatement)statement;
                boolean hasValue = ConsistentReturnCheck.hasValue(returnStatement);
                issue.secondary(statement, String.format("Return %s value", hasValue ? "with" : "without"));
                continue;
            }
            if (statement.is(new Tree.Kind[]{Tree.Kind.IF_STMT, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT})) {
                issue.secondary(statement.firstToken(), "Implicit return without value if the condition is false");
                continue;
            }
            if (statement.is(new Tree.Kind[]{Tree.Kind.MATCH_STMT})) {
                issue.secondary(statement.firstToken(), "Implicit return without value when no case matches");
                continue;
            }
            if (statement.is(new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.CLASSDEF})) {
                issue.secondary(statement.firstToken(), "Implicit return without value");
                continue;
            }
            issue.secondary(statement, "Implicit return without value");
        }
    }

    private static boolean hasValue(ReturnStatement returnStatement) {
        return !returnStatement.expressions().isEmpty();
    }

    private static Statement parentStatement(Tree tree) {
        while (!(tree instanceof Statement)) {
            tree = tree.parent();
        }
        return (Statement)tree;
    }
}

