/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5754")
public class IgnoredSystemExitCheck
extends PythonSubscriptionCheck {
    private static final String BASE_EXCEPTION_NAME = "BaseException";
    private static final String SYSTEM_EXIT_EXCEPTION_NAME = "SystemExit";
    private static final String MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION = "Reraise this exception to stop the application as the user expects";
    private static final String MESSAGE_BARE_EXCEPT = "Specify an exception class to catch or reraise the exception";
    private static final String MESSAGE_NOT_RERAISED_BASE_EXCEPTION = "Catch a more specific exception or reraise the exception";
    private static final String SYSTEM_EXIT_FUNCTION_NAME = "sys.exit";
    private static final String SYSTEM_EXC_INFO_NAME = "sys.exc_info";
    public static final String QUICK_FIX_MESSAGE = "Propagate the exception";

    @CheckForNull
    private static Symbol findExceptionInstanceSymbol(@Nullable Expression exceptionInstance) {
        Symbol exceptionInstanceSymbol = null;
        if (exceptionInstance instanceof HasSymbol) {
            exceptionInstanceSymbol = ((HasSymbol)exceptionInstance).symbol();
        }
        return exceptionInstanceSymbol;
    }

    @CheckForNull
    private static String findExceptionName(Expression exception) {
        Symbol exceptionSymbol;
        if (exception instanceof HasSymbol && (exceptionSymbol = ((HasSymbol)exception).symbol()) != null) {
            return exceptionSymbol.fullyQualifiedName();
        }
        return null;
    }

    private static void handlePossibleBareException(SubscriptionContext ctx, ExceptClause exceptClause, boolean isSystemExitHandled) {
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(null);
        exceptClause.accept((TreeVisitor)visitor);
        if (!visitor.isReRaised && !isSystemExitHandled) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(exceptClause.exceptKeyword(), MESSAGE_BARE_EXCEPT);
            IgnoredSystemExitCheck.addQuickFix(exceptClause, issue);
        }
    }

    private static boolean handleCaughtException(SubscriptionContext ctx, Expression caughtException, @Nullable Symbol exceptionInstanceSymbol, Tree exceptionBody, boolean handledSystemExit) {
        String caughtExceptionName = IgnoredSystemExitCheck.findExceptionName(caughtException);
        if (caughtExceptionName == null) {
            return false;
        }
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(exceptionInstanceSymbol);
        exceptionBody.accept((TreeVisitor)visitor);
        if (visitor.isReRaised) {
            return SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName);
        }
        if (SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)caughtException, MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION);
            IgnoredSystemExitCheck.addQuickFix(caughtException, issue);
            return true;
        }
        if (BASE_EXCEPTION_NAME.equals(caughtExceptionName) && !handledSystemExit) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)caughtException, MESSAGE_NOT_RERAISED_BASE_EXCEPTION);
            IgnoredSystemExitCheck.addQuickFix(caughtException, issue);
        }
        return false;
    }

    private static void addQuickFix(Expression caughtException, PythonCheck.PreciseIssue issue) {
        Optional.of(caughtException).map(e -> TreeUtils.firstAncestor((Tree)caughtException, p -> p.is(new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE}))).map(ExceptClause.class::cast).ifPresent(exceptClause -> IgnoredSystemExitCheck.addQuickFix(exceptClause, issue));
    }

    private static void addQuickFix(ExceptClause exceptClause, PythonCheck.PreciseIssue issue) {
        List bodyStatements = exceptClause.body().statements();
        Statement lastStatement = (Statement)bodyStatements.get(bodyStatements.size() - 1);
        PythonQuickFix.Builder quickFixBuilder = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE);
        if (lastStatement.is(new Tree.Kind[]{Tree.Kind.PASS_STMT}) || TreeUtils.hasDescendant((Tree)lastStatement, c -> c.is(new Tree.Kind[]{Tree.Kind.ELLIPSIS}))) {
            quickFixBuilder.addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)lastStatement, (String)"raise")});
        } else {
            Token lastToken = lastStatement.lastToken();
            quickFixBuilder.addTextEdit(new PythonTextEdit[]{TextEditUtils.insertLineAfter((Tree)lastToken, (Tree)lastStatement, (String)"raise")});
        }
        issue.addQuickFix(quickFixBuilder.build());
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            boolean isSystemExitHandled = false;
            for (ExceptClause exceptClause : tryStatement.exceptClauses()) {
                Expression exceptionExpr = exceptClause.exception();
                if (exceptionExpr == null) {
                    IgnoredSystemExitCheck.handlePossibleBareException(ctx, exceptClause, isSystemExitHandled);
                    break;
                }
                Expression exceptionInstance = exceptClause.exceptionInstance();
                Symbol exceptionInstanceSymbol = IgnoredSystemExitCheck.findExceptionInstanceSymbol(exceptionInstance);
                List caughtExceptions = TreeUtils.flattenTuples((Expression)exceptionExpr).collect(Collectors.toList());
                for (Expression caughtException : caughtExceptions) {
                    isSystemExitHandled |= IgnoredSystemExitCheck.handleCaughtException(ctx, caughtException, exceptionInstanceSymbol, (Tree)exceptClause.body(), isSystemExitHandled);
                }
            }
        });
    }

    private static class ExceptionReRaiseCheckVisitor
    extends BaseTreeVisitor {
        private Symbol exceptionInstance;
        private boolean isReRaised;

        public ExceptionReRaiseCheckVisitor(@Nullable Symbol exceptionInstance) {
            this.exceptionInstance = exceptionInstance;
        }

        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            if (pyRaiseStatementTree.expressions().isEmpty()) {
                this.isReRaised = true;
                return;
            }
            Expression raisedException = (Expression)pyRaiseStatementTree.expressions().get(0);
            if (raisedException.type().canOnlyBe(IgnoredSystemExitCheck.SYSTEM_EXIT_EXCEPTION_NAME)) {
                this.isReRaised = true;
            }
            if (raisedException instanceof HasSymbol) {
                Symbol symbol = ((HasSymbol)raisedException).symbol();
                if (symbol == null) {
                    return;
                }
                if (symbol.equals(this.exceptionInstance)) {
                    this.isReRaised = true;
                }
            }
        }

        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            Symbol symbol = pyCallExpressionTree.calleeSymbol();
            if (symbol == null) {
                return;
            }
            String fqn = symbol.fullyQualifiedName();
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXIT_FUNCTION_NAME.equals(fqn);
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXC_INFO_NAME.equals(fqn);
        }
    }
}

