/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.FunctionDefImpl;

@Rule(key="S6540")
public class MandatoryFunctionParameterTypeHintCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a type hint to this function parameter.";
    private static final List<String> SPECIAL_TOKEN_PARAMS = Arrays.asList("*", "/");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDefImpl functionDef = (FunctionDefImpl)ctx.syntaxNode();
            ParameterList parameterList = functionDef.parameters();
            FunctionSymbol functionSymbol = functionDef.functionSymbol();
            if (parameterList != null) {
                List parameters = parameterList.nonTuple();
                for (int i = 0; i < parameters.size(); ++i) {
                    boolean isFirstParameter;
                    Parameter parameter = (Parameter)parameters.get(i);
                    boolean bl = isFirstParameter = i == 0;
                    if (!MandatoryFunctionParameterTypeHintCheck.shouldRaiseIssue(functionSymbol, parameter, isFirstParameter)) continue;
                    ctx.addIssue((Tree)parameter, MESSAGE);
                }
            }
        });
    }

    private static boolean shouldRaiseIssue(@Nullable FunctionSymbol functionSymbol, Parameter parameter, boolean isFirstParameter) {
        return !MandatoryFunctionParameterTypeHintCheck.isASelfInstanceParameter(parameter, functionSymbol) && !MandatoryFunctionParameterTypeHintCheck.isFirstParamOfClassAnnotatedMethod(functionSymbol, isFirstParameter) && !MandatoryFunctionParameterTypeHintCheck.isFirstParamOfNewMethod(functionSymbol, isFirstParameter) && !MandatoryFunctionParameterTypeHintCheck.isSpecialCharParameter(parameter) && parameter.starToken() == null && parameter.typeAnnotation() == null;
    }

    private static boolean isASelfInstanceParameter(Parameter parameter, @Nullable FunctionSymbol functionSymbol) {
        return MandatoryFunctionParameterTypeHintCheck.hasName("self", parameter) && functionSymbol != null && functionSymbol.isInstanceMethod();
    }

    private static boolean isFirstParamOfClassAnnotatedMethod(@Nullable FunctionSymbol functionSymbol, boolean isFirstParameter) {
        return functionSymbol != null && functionSymbol.decorators().contains("classmethod") && isFirstParameter;
    }

    private static boolean isFirstParamOfNewMethod(@Nullable FunctionSymbol functionSymbol, boolean isFirstParameter) {
        return functionSymbol != null && "__new__".equals(functionSymbol.name()) && isFirstParameter;
    }

    private static boolean isSpecialCharParameter(Parameter parameter) {
        Name parameterName = parameter.name();
        Token maybeToken = parameter.starToken();
        return MandatoryFunctionParameterTypeHintCheck.hasName("_", parameter) || parameterName == null && MandatoryFunctionParameterTypeHintCheck.isSpecialTokenParameter(maybeToken) != false;
    }

    private static Boolean isSpecialTokenParameter(@Nullable Token maybeToken) {
        return Optional.ofNullable(maybeToken).map(token -> SPECIAL_TOKEN_PARAMS.contains(token.value())).orElse(false);
    }

    private static boolean hasName(String name, Parameter parameter) {
        return Optional.ofNullable(parameter.name()).map(parameterName -> name.equals(parameterName.name())).orElse(false);
    }
}

