/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2772")
public class NeedlessPassCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this unneeded \"pass\".";
    public static final String QUICK_FIX_MESSAGE = "Remove the \"pass\" statement";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            List statements = ((StatementList)ctx.syntaxNode()).statements().stream().filter(NeedlessPassCheck::isNotStringLiteralExpressionStatement).collect(Collectors.toList());
            if (statements.size() <= 1) {
                return;
            }
            statements.stream().filter(st -> st.is(new Tree.Kind[]{Tree.Kind.PASS_STMT})).findFirst().ifPresent(st -> {
                PythonTextEdit textEdit = NeedlessPassCheck.createRemoveStatementTextEdit(statements, st);
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{textEdit}).build();
                ctx.addIssue((Tree)st, MESSAGE).addQuickFix(quickFix);
            });
        });
    }

    private static PythonTextEdit createRemoveStatementTextEdit(List<Statement> statements, Statement toRemove) {
        boolean last;
        int removeIndex = statements.indexOf(toRemove);
        boolean bl = last = removeIndex == statements.size() - 1;
        if (last) {
            Statement previous = statements.get(removeIndex - 1);
            Token removeFrom = TreeUtils.getTreeSeparatorOrLastToken((Tree)previous);
            Token removeTo = TreeUtils.getTreeSeparatorOrLastToken((Tree)toRemove);
            return TextEditUtils.removeRange((int)removeFrom.line(), (int)removeFrom.column(), (int)removeTo.line(), (int)removeTo.column());
        }
        return TextEditUtils.removeUntil((Tree)toRemove, (Tree)((Tree)statements.get(removeIndex + 1)));
    }

    private static boolean isNotStringLiteralExpressionStatement(Statement st) {
        return !st.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT}) || !((ExpressionStatement)st).expressions().stream().allMatch(e -> e.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}));
    }
}

