/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="OneStatementPerLine")
public class OneStatementPerLineCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "OneStatementPerLine";
    private final Map<Integer, Integer> statementsPerLine = new HashMap<Integer, Integer>();
    private SubscriptionContext subscriptionContext;
    private static final List<Tree.Kind> kinds = Arrays.asList(Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.COMPOUND_ASSIGNMENT, Tree.Kind.EXPRESSION_STMT, Tree.Kind.IMPORT_NAME, Tree.Kind.IMPORT_FROM, Tree.Kind.CONTINUE_STMT, Tree.Kind.BREAK_STMT, Tree.Kind.YIELD_STMT, Tree.Kind.RETURN_STMT, Tree.Kind.PRINT_STMT, Tree.Kind.PASS_STMT, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT, Tree.Kind.IF_STMT, Tree.Kind.ELSE_CLAUSE, Tree.Kind.RAISE_STMT, Tree.Kind.TRY_STMT, Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.EXEC_STMT, Tree.Kind.ASSERT_STMT, Tree.Kind.DEL_STMT, Tree.Kind.GLOBAL_STMT, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF);

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.statementsPerLine.clear();
            this.subscriptionContext = ctx;
        });
        kinds.forEach(k -> context.registerSyntaxNodeConsumer(k, this::checkStatement));
    }

    private void checkStatement(SubscriptionContext ctx) {
        int line = ctx.syntaxNode().firstToken().line();
        if (!this.statementsPerLine.containsKey(line)) {
            this.statementsPerLine.put(line, 0);
        }
        this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
    }

    public void leaveFile() {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            String message = String.format("At most one statement is allowed per line, but %s statements were found on this line.", statementsAtLine.getValue());
            int lineNumber = statementsAtLine.getKey();
            this.subscriptionContext.addLineIssue(message, lineNumber);
        }
    }
}

