/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S6742")
public class PandasChainInstructionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Refactor this long chain of instructions with pandas.pipe";
    private static final int MAX_CHAIN_LENGTH = 7;
    private static final String DATAFRAME_FQN = "pandas.core.frame.DataFrame";
    private final Set<QualifiedExpression> visited = new HashSet<QualifiedExpression>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> this.visited.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.QUALIFIED_EXPR, this::checkChainedInstructions);
    }

    private void checkChainedInstructions(SubscriptionContext ctx) {
        QualifiedExpression expr = (QualifiedExpression)ctx.syntaxNode();
        List<QualifiedExpression> chain = this.visitQualifier(expr, new ArrayList<QualifiedExpression>());
        if (chain.size() >= 7 && PandasChainInstructionCheck.isValidPandasCall(chain)) {
            ctx.addIssue((Tree)chain.iterator().next(), MESSAGE);
        }
    }

    private List<QualifiedExpression> visitQualifier(QualifiedExpression expr, List<QualifiedExpression> chain) {
        if (this.visited.contains(expr)) {
            return chain;
        }
        this.visited.add(expr);
        chain.add(expr);
        if (expr.qualifier().is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return this.visitCalleeQualifier((CallExpression)expr.qualifier(), chain);
        }
        if (expr.qualifier().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return this.visitQualifier((QualifiedExpression)expr.qualifier(), chain);
        }
        if (expr.qualifier().is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            return PandasChainInstructionCheck.ignoreSubscriptionAndGetCallExpr((SubscriptionExpression)expr.qualifier()).map(callExpr -> this.visitCalleeQualifier((CallExpression)callExpr, chain)).orElse(chain);
        }
        return chain;
    }

    private List<QualifiedExpression> visitCalleeQualifier(CallExpression call, List<QualifiedExpression> chain) {
        return Optional.of(call.callee()).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(qe -> this.visitQualifier((QualifiedExpression)qe, chain)).orElse(chain);
    }

    private static Optional<CallExpression> ignoreSubscriptionAndGetCallExpr(SubscriptionExpression qualifier) {
        if (qualifier.object().is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return Optional.of((CallExpression)qualifier.object());
        }
        if (qualifier.object().is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            return PandasChainInstructionCheck.ignoreSubscriptionAndGetCallExpr((SubscriptionExpression)qualifier.object());
        }
        return Optional.empty();
    }

    private static boolean isValidPandasCall(List<QualifiedExpression> chain) {
        QualifiedExpression firstQualifiedExpression = chain.get(chain.size() - 1);
        boolean isADataFrameMethodCall = Optional.ofNullable(firstQualifiedExpression.symbol()).map(Symbol::fullyQualifiedName).filter(fqn -> fqn.startsWith(DATAFRAME_FQN)).isPresent();
        boolean isAFunctionReturningADataFrame = Optional.ofNullable(firstQualifiedExpression.symbol()).flatMap(PandasChainInstructionCheck::isReturnTypeADataFrame).orElse(false);
        boolean doesNotContainACallToPipe = chain.stream().map(QualifiedExpression::symbol).filter(Objects::nonNull).map(Symbol::fullyQualifiedName).filter(Objects::nonNull).noneMatch("pandas.core.frame.DataFrame.pipe"::equals);
        boolean isADataFrame = "DataFrame".equals(InferredTypes.typeName((InferredType)firstQualifiedExpression.qualifier().type()));
        return (isADataFrameMethodCall || isAFunctionReturningADataFrame || isADataFrame) && doesNotContainACallToPipe;
    }

    private static Optional<Boolean> isReturnTypeADataFrame(Symbol symbol) {
        return Optional.of(symbol).filter(s -> s.is(new Symbol.Kind[]{Symbol.Kind.AMBIGUOUS})).map(AmbiguousSymbol.class::cast).map(s -> s.alternatives().stream().filter(a -> a.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})).map(FunctionSymbol.class::cast).map(FunctionSymbol::annotatedReturnTypeName).anyMatch(DATAFRAME_FQN::equals)).or(() -> Optional.of(symbol).filter(s -> s.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})).map(FunctionSymbol.class::cast).map(FunctionSymbol::annotatedReturnTypeName).map(DATAFRAME_FQN::equals));
    }
}

