/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6734")
public class PandasModifyInPlaceCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Do not use 'inplace=True' when modifying a dataframe.";
    private static final Set<String> FULLY_QUALIFIED_EXPRESSIONS = Set.of("pandas.core.frame.DataFrame.drop", "pandas.core.frame.DataFrame.dropna", "pandas.core.frame.DataFrame.drop_duplicates", "pandas.core.frame.DataFrame.sort_values", "pandas.core.frame.DataFrame.sort_index", "pandas.core.frame.DataFrame.eval", "pandas.core.frame.DataFrame.query");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, PandasModifyInPlaceCheck::checkInplaceParameter);
    }

    private static void checkInplaceParameter(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(FULLY_QUALIFIED_EXPRESSIONS::contains).map(fqn -> TreeUtils.argumentByKeyword((String)"inplace", (List)callExpression.arguments())).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).map(Name::name).filter("True"::equals).flatMap(fqn -> Optional.ofNullable(TreeUtils.argumentByKeyword((String)"inplace", (List)callExpression.arguments()))).ifPresent(regularArgument -> ctx.addIssue((Tree)regularArgument, MESSAGE));
    }
}

