/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6740")
public class PandasReadNoDataTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Provide the 'dtype' parameter when calling";
    private static final String READ_CSV = "pandas.read_csv";
    private static final String READ_TABLE = "pandas.read_table";
    private static final Map<String, String> READ_METHODS = Map.of("pandas.read_csv", "pandas.read_csv", "pandas.read_table", "pandas.read_table", "pandas.io.parsers.readers.read_csv", "pandas.read_csv", "pandas.io.parsers.readers.read_table", "pandas.read_table");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, PandasReadNoDataTypeCheck::checkReadMethodCall);
    }

    private static void checkReadMethodCall(SubscriptionContext subscriptionContext) {
        CallExpression callExpression = (CallExpression)subscriptionContext.syntaxNode();
        Optional.of(callExpression).filter(PandasReadNoDataTypeCheck::isReadCall).filter(ce -> TreeUtils.nthArgumentOrKeyword((int)1, (String)"dtype", (List)ce.arguments()) == null).flatMap(PandasReadNoDataTypeCheck::getNameTree).ifPresent(name -> subscriptionContext.addIssue((Tree)name, PandasReadNoDataTypeCheck.getMessage(callExpression)));
    }

    private static boolean isReadCall(CallExpression callExpression) {
        return Optional.of(callExpression).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter(PandasReadNoDataTypeCheck::isPandasReadCall).isPresent();
    }

    private static Optional<Name> getNameTree(CallExpression expression) {
        return Optional.of(expression.callee()).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::name).or(() -> Optional.of(expression.callee()).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)));
    }

    private static boolean isPandasReadCall(String fqn) {
        return READ_METHODS.containsKey(fqn);
    }

    private static String getMessage(CallExpression ce) {
        return Optional.ofNullable(ce.calleeSymbol()).map(Symbol::fullyQualifiedName).map(READ_METHODS::get).map(name -> String.format("%s '%s'.", MESSAGE, name)).orElse("");
    }
}

