/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
implements PythonCheck {
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern TRAILING_WS = Pattern.compile("\\s\\s*+$");

    public void scanFile(PythonVisitorContext ctx) {
        String[] lines = ctx.pythonFile().content().split("\r\n|\n|\r", -1);
        for (int i = 0; i < lines.length; ++i) {
            Matcher matcher = TRAILING_WS.matcher(lines[i]);
            if (!matcher.find()) continue;
            int lineNumber = i + 1;
            PythonCheck.PreciseIssue issue = new PythonCheck.PreciseIssue((PythonCheck)this, IssueLocation.atLineLevel((String)MESSAGE, (int)lineNumber));
            issue.addQuickFix(PythonQuickFix.newQuickFix((String)"Remove trailing whitespaces").addTextEdit(new PythonTextEdit[]{TextEditUtils.removeRange((int)lineNumber, (int)matcher.start(), (int)lineNumber, (int)matcher.end())}).build());
            ctx.addIssue(issue);
        }
    }
}

