/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.Tuple;

@Rule(key="S1045")
public class UnreachableExceptCheck
extends PythonSubscriptionCheck {
    private static final String SECONDARY_MESSAGE = "Exceptions will be caught here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            HashMap<String, Expression> caughtTypes = new HashMap<String, Expression>();
            for (ExceptClause exceptClause : tryStatement.exceptClauses()) {
                UnreachableExceptCheck.handleExceptClause(ctx, caughtTypes, exceptClause);
            }
        });
    }

    private static void handleExceptClause(SubscriptionContext ctx, Map<String, Expression> caughtTypes, ExceptClause exceptClause) {
        HashMap<String, Expression> caughtInExceptClause = new HashMap<String, Expression>();
        Expression exceptionExpression = exceptClause.exception();
        if (exceptionExpression == null) {
            Expression baseExceptionExpression = caughtTypes.get("BaseException");
            if (baseExceptionExpression != null) {
                ctx.addIssue(exceptClause.exceptKeyword(), "Merge this bare \"except:\" with the \"BaseException\" one.").secondary((Tree)baseExceptionExpression, SECONDARY_MESSAGE);
            }
            return;
        }
        if (exceptionExpression.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            Tuple tuple = (Tuple)exceptionExpression;
            for (Expression expression : tuple.elements()) {
                UnreachableExceptCheck.handleExceptionExpression(ctx, caughtTypes, expression, caughtInExceptClause);
            }
        } else {
            UnreachableExceptCheck.handleExceptionExpression(ctx, caughtTypes, exceptionExpression, caughtInExceptClause);
        }
        caughtInExceptClause.forEach(caughtTypes::putIfAbsent);
    }

    private static void handleExceptionExpression(SubscriptionContext ctx, Map<String, Expression> caughtTypes, Expression exceptionExpression, Map<String, Expression> caughtInExceptClause) {
        List<Expression> handledExceptions;
        if (!(exceptionExpression instanceof HasSymbol)) {
            return;
        }
        Symbol symbol = ((HasSymbol)exceptionExpression).symbol();
        if (symbol == null) {
            return;
        }
        String symbolName = UnreachableExceptCheck.getSymbolName(symbol).orElse(null);
        List<Expression> list = handledExceptions = Symbol.Kind.CLASS == symbol.kind() ? UnreachableExceptCheck.retrieveAlreadyHandledExceptionsByClass((ClassSymbol)symbol, caughtTypes) : UnreachableExceptCheck.retrieveAlreadyHandledExceptionsByFullyQualifiedName(symbol, caughtTypes);
        if (!handledExceptions.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)exceptionExpression, "Catch this exception only once; it is already handled by a previous except clause.");
            handledExceptions.forEach(h -> issue.secondary((Tree)h, SECONDARY_MESSAGE));
        }
        caughtInExceptClause.put(symbolName, exceptionExpression);
    }

    private static List<Expression> retrieveAlreadyHandledExceptionsByClass(ClassSymbol classSymbol, Map<String, Expression> caughtTypes) {
        return caughtTypes.keySet().stream().filter(arg_0 -> ((ClassSymbol)classSymbol).isOrExtends(arg_0)).map(caughtTypes::get).collect(Collectors.toList());
    }

    private static List<Expression> retrieveAlreadyHandledExceptionsByFullyQualifiedName(Symbol symbol, Map<String, Expression> caughtTypes) {
        return UnreachableExceptCheck.getSymbolName(symbol).filter(caughtTypes::containsKey).map(caughtTypes::get).stream().collect(Collectors.toList());
    }

    private static Optional<String> getSymbolName(Symbol symbol) {
        return Optional.ofNullable(symbol.fullyQualifiedName()).or(() -> Optional.ofNullable(symbol.name()));
    }
}

