/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.TreeUtils;

public class ClearTextProtocolsCheckPart
extends AbstractCdkResourceCheck {
    private static final String LB_MESSAGE = "Make sure that using network protocols without an SSL/TLS underlay is safe here.";
    private static final String ELASTICACHE_MESSAGE = "Make sure that disabling transit encryption is safe here.";
    private static final String KINESIS_MESSAGE = "Make sure that disabling stream encryption is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting `%s` causes %s encryption to be disabled. Make sure it is safe here.";
    private static final String PROTOCOL = "protocol";
    private static final String EXTERNAL_PROTOCOL_SNAKE_CASE = "external_protocol";
    private static final String EXTERNAL_PROTOCOL_CAMEL_CASE = "externalProtocol";
    private static final String LISTENERS = "listeners";
    private static final Set<Integer> HTTP_PROTOCOL_PORTS = Set.of(Integer.valueOf(80), Integer.valueOf(8080), Integer.valueOf(8000), Integer.valueOf(8008));

    @Override
    protected void registerFqnConsumer() {
        this.checkFqns(List.of(Elb.prefix("LoadBalancerListener"), Elb.prefix("LoadBalancer.add_listener")), (ctx, call) -> CdkUtils.getArgument(ctx, call, EXTERNAL_PROTOCOL_SNAKE_CASE).ifPresent(protocol -> protocol.addIssueIf(ClearTextProtocolsCheckPart.isSensitiveTransportProtocolFqn(Elb.SENSITIVE_TRANSPORT_PROTOCOL_FQNS), LB_MESSAGE, new IssueLocation[0])));
        this.checkFqn(Elb.prefix("LoadBalancer"), (ctx, call) -> CdkUtils.getArgument(ctx, call, LISTENERS).flatMap(CdkUtils::getList).ifPresent(listeners -> CdkUtils.getDictionaryInList(ctx, listeners).forEach(dict -> ClearTextProtocolsCheckPart.checkLoadBalancerListenerDict(ctx, dict))));
        this.checkFqn(Elb.prefix("CfnLoadBalancer"), (ctx, call) -> CdkUtils.getArgument(ctx, call, LISTENERS).flatMap(CdkUtils::getList).ifPresent(listeners -> CdkUtils.getDictionaryInList(ctx, listeners).forEach(dict -> ClearTextProtocolsCheckPart.checkCfnLoadBalancerListenerDict(ctx, dict))));
        this.checkFqn(Elb.prefix("CfnLoadBalancer.ListenersProperty"), (ctx, call) -> CdkUtils.getArgument(ctx, call, PROTOCOL).ifPresent(protocol -> protocol.addIssueIf(ClearTextProtocolsCheckPart.isSensitiveTransportProtocol(Elb.SENSITIVE_TRANSPORT_PROTOCOLS), LB_MESSAGE, new IssueLocation[0])));
        this.checkFqns(List.of(Elbv2.prefix("ApplicationListener"), Elbv2.prefix("ApplicationLoadBalancer.add_listener")), (ctx, call) -> CdkUtils.getArgument(ctx, call, PROTOCOL).ifPresentOrElse(protocol -> protocol.addIssueIf(CdkPredicate.isFqn(Elbv2.SENSITIVE_HTTP_PROTOCOL_FQN), LB_MESSAGE, new IssueLocation[0]), () -> CdkUtils.getArgument(ctx, call, "port").ifPresent(port -> port.addIssueIf(ClearTextProtocolsCheckPart.isSensitiveHttpProtocolPort(), LB_MESSAGE, new IssueLocation[0]))));
        this.checkFqns(List.of(Elbv2.prefix("NetworkListener"), Elbv2.prefix("NetworkLoadBalancer.add_listener")), (ctx, call) -> CdkUtils.getArgument(ctx, call, PROTOCOL).ifPresentOrElse(protocol -> protocol.addIssueIf(ClearTextProtocolsCheckPart.isSensitiveTransportProtocolFqn(Elbv2.SENSITIVE_TRANSPORT_PROTOCOL_FQNS), LB_MESSAGE, new IssueLocation[0]), () -> CdkUtils.getArgument(ctx, call, "certificates").ifPresentOrElse(certificates -> certificates.addIssueIf(ClearTextProtocolsCheckPart.isEmpty(), LB_MESSAGE, (CallExpression)call), () -> ctx.addIssue((Tree)call, LB_MESSAGE))));
        this.checkFqn(Elbv2.prefix("CfnListener"), (ctx, call) -> CdkUtils.getArgument(ctx, call, PROTOCOL).ifPresent(protocol -> protocol.addIssueIf(ClearTextProtocolsCheckPart.isSensitiveTransportProtocol(Elbv2.SENSITIVE_TRANSPORT_PROTOCOLS), LB_MESSAGE, new IssueLocation[0])));
        this.checkFqn("aws_cdk.aws_elasticache.CfnReplicationGroup", (ctx, call) -> CdkUtils.getArgument(ctx, call, "transit_encryption_enabled").ifPresentOrElse(transitEncryption -> transitEncryption.addIssueIf(CdkPredicate.isFalse(), ELASTICACHE_MESSAGE, new IssueLocation[0]), () -> ctx.addIssue((Tree)call.callee(), String.format(OMITTING_MESSAGE, "transit_encryption_enabled", "transit"))));
        this.checkFqn(Kinesis.prefix("CfnStream"), (ctx, call) -> CdkUtils.getArgument(ctx, call, "stream_encryption").ifPresentOrElse(streamEncryption -> streamEncryption.addIssueIf(CdkPredicate.isNone(), KINESIS_MESSAGE, new IssueLocation[0]), () -> ctx.addIssue((Tree)call.callee(), String.format(OMITTING_MESSAGE, "stream_encryption", "stream"))));
        this.checkFqn(Kinesis.prefix("Stream"), (ctx, call) -> CdkUtils.getArgument(ctx, call, "encryption").ifPresent(encryption -> encryption.addIssueIf(CdkPredicate.isFqn(Kinesis.SENSITIVE_STREAM_ENCRYPTION_FQN), KINESIS_MESSAGE, new IssueLocation[0])));
    }

    private static void checkLoadBalancerListenerDict(SubscriptionContext ctx, DictionaryLiteral dict) {
        ClearTextProtocolsCheckPart.checkKeyValuePair(ctx, dict, Set.of(EXTERNAL_PROTOCOL_SNAKE_CASE, EXTERNAL_PROTOCOL_CAMEL_CASE), ClearTextProtocolsCheckPart.isSensitiveTransportProtocolFqn(Elb.SENSITIVE_TRANSPORT_PROTOCOL_FQNS));
    }

    private static void checkCfnLoadBalancerListenerDict(SubscriptionContext ctx, DictionaryLiteral dict) {
        ClearTextProtocolsCheckPart.checkKeyValuePair(ctx, dict, PROTOCOL, ClearTextProtocolsCheckPart.isSensitiveTransportProtocol(Elb.SENSITIVE_TRANSPORT_PROTOCOLS));
    }

    private static void checkKeyValuePair(SubscriptionContext ctx, DictionaryLiteral dict, String key, Predicate<Expression> expected) {
        ClearTextProtocolsCheckPart.checkKeyValuePair(ctx, dict, Set.of(key), expected);
    }

    private static void checkKeyValuePair(SubscriptionContext ctx, DictionaryLiteral dict, Set<String> keys, Predicate<Expression> expected) {
        keys.stream().map(key -> CdkUtils.getDictionaryPair(ctx, dict, key)).filter(Optional::isPresent).findFirst().map(Optional::get).ifPresent(pair -> pair.value.addIssueIf(expected, LB_MESSAGE, new IssueLocation[0]));
    }

    private static Predicate<Expression> isEmpty() {
        return expression -> expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}) && ((ListLiteral)expression).elements().expressions().isEmpty();
    }

    private static Predicate<Expression> isSensitiveTransportProtocol(Collection<String> transportProtocols) {
        return expression -> CdkUtils.getString(expression).filter(transportProtocols::contains).isPresent();
    }

    private static Predicate<Expression> isSensitiveTransportProtocolFqn(Collection<String> transportProtocolFqns) {
        return expression -> Optional.ofNullable(TreeUtils.fullyQualifiedNameFromExpression((Expression)expression)).filter(transportProtocolFqns::contains).isPresent();
    }

    private static Predicate<Expression> isSensitiveHttpProtocolPort() {
        return expression -> CdkUtils.getInt(expression).filter(HTTP_PROTOCOL_PORTS::contains).isPresent();
    }

    private static class Kinesis {
        private static final String SENSITIVE_STREAM_ENCRYPTION_FQN = Kinesis.prefix("StreamEncryption.UNENCRYPTED");

        private Kinesis() {
        }

        static String prefix(String lbName) {
            return "aws_cdk.aws_kinesis." + lbName;
        }
    }

    private static class Elbv2 {
        private static final String SENSITIVE_HTTP_PROTOCOL_FQN = Elbv2.prefix("ApplicationProtocol.HTTP");
        private static final Set<String> SENSITIVE_TRANSPORT_PROTOCOL_FQNS = Set.of(Elbv2.prefix("Protocol.TCP"), Elbv2.prefix("Protocol.UDP"), Elbv2.prefix("Protocol.TCP_UDP"));
        private static final Set<String> SENSITIVE_TRANSPORT_PROTOCOLS = Set.of("HTTP", "TCP", "UDP", "TCP_UDP");

        private Elbv2() {
        }

        static String prefix(String lbName) {
            return "aws_cdk.aws_elasticloadbalancingv2." + lbName;
        }
    }

    private static class Elb {
        private static final Set<String> SENSITIVE_TRANSPORT_PROTOCOL_FQNS = Set.of(Elb.prefix("LoadBalancingProtocol.TCP"), Elb.prefix("LoadBalancingProtocol.HTTP"));
        private static final Set<String> SENSITIVE_TRANSPORT_PROTOCOLS = Set.of("http", "tcp");

        private Elb() {
        }

        static String prefix(String lbName) {
            return "aws_cdk.aws_elasticloadbalancing." + lbName;
        }
    }
}

