/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6265")
public class S3BucketGrantedAccessCheck
extends AbstractS3BucketCheck {
    public static final String MESSAGE_POLICY = "Make sure granting %s access is safe here.";
    public static final String MESSAGE_GRANT = "Make sure allowing unrestricted access to objects from this bucket is safe here.";
    private static final String S3_BUCKET_DEPLOYMENT_FQN = "aws_cdk.aws_s3_deployment.BucketDeployment";
    private static final String S3_BUCKET_AUTHENTICATED_READ = "aws_cdk.aws_s3.BucketAccessControl.AUTHENTICATED_READ";
    private static final String S3_BUCKET_PUBLIC_READ = "aws_cdk.aws_s3.BucketAccessControl.PUBLIC_READ";
    private static final String S3_BUCKET_PUBLIC_READ_WRITE = "aws_cdk.aws_s3.BucketAccessControl.PUBLIC_READ_WRITE";
    private static final List<String> S3_BUCKET_FQNS = List.of("aws_cdk.aws_s3.Bucket", "aws_cdk.aws_s3_deployment.BucketDeployment");
    private static final List<String> S3_BUCKET_SENSITIVE_POLICIES = List.of("aws_cdk.aws_s3.BucketAccessControl.AUTHENTICATED_READ", "aws_cdk.aws_s3.BucketAccessControl.PUBLIC_READ", "aws_cdk.aws_s3.BucketAccessControl.PUBLIC_READ_WRITE");
    private boolean isAwsCdkImported = false;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        super.initialize(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.isAwsCdkImported = false;
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_FROM, this::checkAWSImport);
    }

    private void checkAWSImport(SubscriptionContext ctx) {
        ImportFrom imports = (ImportFrom)ctx.syntaxNode();
        Optional.ofNullable(imports.module()).filter(dottedName -> dottedName.names().stream().map(Name::name).anyMatch("aws_cdk"::equals)).ifPresent(n -> {
            this.isAwsCdkImported = true;
        });
    }

    @Override
    protected void visitNode(SubscriptionContext ctx) {
        CallExpression node = (CallExpression)ctx.syntaxNode();
        Optional<Symbol> symbol = Optional.ofNullable(node.calleeSymbol());
        symbol.map(Symbol::fullyQualifiedName).filter(S3_BUCKET_FQNS::contains).ifPresent(s -> this.visitBucketConstructor().accept(ctx, node));
        if (this.isAwsCdkImported) {
            symbol.map(Symbol::name).filter("grant_public_access"::equals).ifPresent(s -> ctx.addIssue((Tree)node.callee(), MESSAGE_GRANT));
        }
    }

    @Override
    BiConsumer<SubscriptionContext, CallExpression> visitBucketConstructor() {
        return (ctx, bucket) -> CdkUtils.getArgument(ctx, bucket, "access_control").ifPresent(argument -> argument.addIssueIf(CdkPredicate.isFqnOf(S3_BUCKET_SENSITIVE_POLICIES), S3BucketGrantedAccessCheck.getSensitivePolicyMessage(argument), new IssueLocation[0]));
    }

    private static String getSensitivePolicyMessage(CdkUtils.ExpressionFlow flow) {
        String attribute = ((QualifiedExpression)flow.locations().getLast()).name().name();
        return String.format(MESSAGE_POLICY, attribute);
    }
}

