/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.django;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6552")
public class DjangoReceiverDecoratorCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Move this '@receiver' decorator to the top of the other decorators.";
    private static final String QUICK_FIX_MESSAGE = "Move the '@receiver' decorator to the top";
    private static final String RECEIVER_DECORATOR_FQN = "django.dispatch.receiver";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            List decorators = functionDef.decorators();
            decorators.stream().filter(DjangoReceiverDecoratorCheck::isReceiverDecorator).findFirst().ifPresent(receiverDecorator -> {
                if (decorators.indexOf(receiverDecorator) != 0) {
                    PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)receiverDecorator, MESSAGE);
                    DjangoReceiverDecoratorCheck.addQuickFix(issue, functionDef, receiverDecorator);
                }
            });
        });
    }

    private static boolean isReceiverDecorator(Decorator decorator) {
        return Optional.of(decorator).map(Decorator::expression).map(TreeUtils::fullyQualifiedNameFromExpression).filter(RECEIVER_DECORATOR_FQN::equals).isPresent();
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, FunctionDef functionDef, Decorator decorator) {
        PythonQuickFix.Builder builder = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE);
        List decorators = functionDef.decorators();
        int decoratorPosition = decorators.indexOf(decorator);
        Token removeTo = decorators.size() == decoratorPosition + 1 ? functionDef.defKeyword() : (Tree)decorators.get(decoratorPosition + 1);
        Optional.of(decorator).map(d -> TreeUtils.treeToString((Tree)d, (boolean)true)).map(decoratorString -> TextEditUtils.insertBefore((Tree)((Tree)decorators.get(0)), (String)decoratorString)).ifPresent(xva$0 -> builder.addTextEdit(new PythonTextEdit[]{xva$0}));
        PythonTextEdit removeEdit = TextEditUtils.removeUntil((Tree)decorator, (Tree)removeTo);
        builder.addTextEdit(new PythonTextEdit[]{removeEdit});
        issue.addQuickFix(builder.build());
    }
}

