/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractNameCheck;

public abstract class AbstractFunctionNameCheck
extends AbstractNameCheck {
    private static final String DEFAULT = "^[a-z_][a-z0-9_]*$";
    private static final String MESSAGE = "Rename %s \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[a-z_][a-z0-9_]*$")
    public String format = "^[a-z_][a-z0-9_]*$";

    @Override
    protected String format() {
        return this.format;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef pyFunctionDefTree = (FunctionDef)ctx.syntaxNode();
            if (!this.shouldCheckFunctionDeclaration(pyFunctionDefTree)) {
                return;
            }
            Name functionNameTree = pyFunctionDefTree.name();
            String name = functionNameTree.name();
            if (!this.pattern().matcher(name).matches()) {
                String message = String.format(MESSAGE, this.typeName(), name, this.format);
                ctx.addIssue((Tree)functionNameTree, message);
            }
        });
    }

    public abstract String typeName();

    public abstract boolean shouldCheckFunctionDeclaration(FunctionDef var1);
}

