/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractNameCheck;

@Rule(key="S101")
public class ClassNameCheck
extends AbstractNameCheck {
    public static final String CHECK_KEY = "S101";
    private static final String DEFAULT = "^_?([A-Z_][a-zA-Z0-9]*|[a-z_][a-z0-9_]*)$";
    private static final String MESSAGE = "Rename class \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", description="Regular expression used to check the class names against", defaultValue="^_?([A-Z_][a-zA-Z0-9]*|[a-z_][a-z0-9_]*)$")
    public String format = "^_?([A-Z_][a-zA-Z0-9]*|[a-z_][a-z0-9_]*)$";

    @Override
    protected String format() {
        return this.format;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef pyClassDefTree = (ClassDef)ctx.syntaxNode();
            Name classNameTree = pyClassDefTree.name();
            String className = classNameTree.name();
            if (!this.pattern().matcher(className).matches()) {
                String message = String.format(MESSAGE, className, this.format);
                ctx.addIssue((Tree)classNameTree, message);
            }
        });
    }
}

