/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2823")
public class NonStringInAllPropertyCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this symbol with a string; \"__all__\" can only contain strings.";
    private static final List<String> ACCEPTED_DECORATORS = Arrays.asList("typing.overload", "overload", "staticmethod", "classmethod");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignmentStatement = (AssignmentStatement)ctx.syntaxNode();
            if (TreeUtils.firstAncestorOfKind((Tree)assignmentStatement, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF}) != null) {
                return;
            }
            ExpressionList expressionList = (ExpressionList)assignmentStatement.lhsExpressions().get(0);
            if (expressionList.expressions().size() > 1) {
                return;
            }
            Expression lhs = (Expression)expressionList.expressions().get(0);
            if (lhs.is(new Tree.Kind[]{Tree.Kind.NAME}) && ((Name)lhs).name().equals("__all__")) {
                NonStringInAllPropertyCheck.checkAllProperty(ctx, assignmentStatement);
            }
        });
    }

    private static void checkAllProperty(SubscriptionContext ctx, AssignmentStatement assignmentStatement) {
        Expression assignedValue = assignmentStatement.assignedValue();
        if (!assignedValue.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}) && !assignedValue.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            return;
        }
        List<Expression> expressions = NonStringInAllPropertyCheck.getAllExpressions(assignedValue);
        for (Expression element : expressions) {
            if (NonStringInAllPropertyCheck.couldBeString(element, new HashSet<Tree>())) continue;
            ctx.addIssue((Tree)element, MESSAGE);
        }
    }

    private static boolean isClassOrFunctionSymbol(@Nullable Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS})) {
            return true;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ACCEPTED_DECORATORS.containsAll(((FunctionSymbol)symbol).decorators());
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.AMBIGUOUS})) {
            return ((AmbiguousSymbol)symbol).alternatives().stream().allMatch(NonStringInAllPropertyCheck::isClassOrFunctionSymbol);
        }
        return false;
    }

    private static List<Expression> getAllExpressions(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL})) {
            return ((ListLiteral)expression).elements().expressions();
        }
        return ((Tuple)expression).elements();
    }

    private static boolean couldBeString(Expression expression, Set<Tree> visitedTrees) {
        HasSymbol hasSymbol;
        if (expression instanceof HasSymbol && NonStringInAllPropertyCheck.isClassOrFunctionSymbol((hasSymbol = (HasSymbol)expression).symbol())) {
            return false;
        }
        if (!expression.type().canBeOrExtend("str")) {
            return false;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.LAMBDA})) {
            return false;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && !visitedTrees.contains(expression)) {
            visitedTrees.add((Tree)expression);
            Expression assignedValue = Expressions.singleAssignedValue((Name)expression);
            return assignedValue == null || NonStringInAllPropertyCheck.couldBeString(assignedValue, visitedTrees);
        }
        return true;
    }
}

