/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

public class Expressions {
    private static final Set<String> ZERO_VALUES = new HashSet<String>(Arrays.asList("0", "0.0", "0j"));
    private static final String TYPE_VAR_FQN = "typing.TypeVar";

    private Expressions() {
    }

    public static boolean isFalsy(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        return switch (expression.getKind()) {
            case Tree.Kind.NAME -> "False".equals(((Name)expression).name());
            case Tree.Kind.NONE -> true;
            case Tree.Kind.STRING_LITERAL -> Expressions.unescape((StringLiteral)expression).isEmpty();
            case Tree.Kind.NUMERIC_LITERAL -> ZERO_VALUES.contains(((NumericLiteral)expression).valueAsString());
            case Tree.Kind.LIST_LITERAL -> ((ListLiteral)expression).elements().expressions().isEmpty();
            case Tree.Kind.TUPLE -> ((Tuple)expression).elements().isEmpty();
            case Tree.Kind.DICTIONARY_LITERAL -> ((DictionaryLiteral)expression).elements().isEmpty();
            default -> false;
        };
    }

    public static boolean isTruthy(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        return switch (expression.getKind()) {
            case Tree.Kind.NAME -> "True".equals(((Name)expression).name());
            case Tree.Kind.STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE, Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.SET_LITERAL -> {
                if (!Expressions.isFalsy(expression)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @CheckForNull
    public static Expression singleAssignedValue(Name name) {
        return Expressions.singleAssignedValue(name, new HashSet<Name>());
    }

    @CheckForNull
    public static Expression singleAssignedValue(Name name, Set<Name> visited) {
        if (visited.contains(name)) {
            return null;
        }
        visited.add(name);
        Symbol symbol = name.symbol();
        if (symbol == null) {
            return null;
        }
        Expression result = null;
        for (Usage usage : symbol.usages()) {
            if (usage.kind() == Usage.Kind.ASSIGNMENT_LHS) {
                if (result != null) {
                    return null;
                }
                Tree parent = usage.tree().parent();
                if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_LIST}) && ((ExpressionList)parent).expressions().size() == 1 && parent.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
                    result = ((AssignmentStatement)parent.parent()).assignedValue();
                    continue;
                }
                return null;
            }
            if (!usage.isBindingUsage()) continue;
            return null;
        }
        return result;
    }

    public static Expression removeParentheses(Expression expression) {
        Expression res = expression;
        while (res.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            res = ((ParenthesizedExpression)res).expression();
        }
        return res;
    }

    public static Optional<Expression> singleAssignedNonNameValue(Name name) {
        HashSet<Name> visited = new HashSet<Name>();
        Expression result = Expressions.singleAssignedValue(name, visited);
        while (result != null && result.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            result = Expressions.singleAssignedValue((Name)result, visited);
        }
        return Optional.ofNullable(result);
    }

    public static Optional<Expression> ifNameGetSingleAssignedNonNameValue(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return Expressions.singleAssignedNonNameValue((Name)expression);
        }
        return Optional.of(expression);
    }

    public static List<Expression> expressionsFromListOrTuple(Expression expression) {
        return TreeUtils.toOptionalInstanceOf(ListLiteral.class, (Tree)expression).map(ListLiteral::elements).map(ExpressionList::expressions).or(() -> TreeUtils.toOptionalInstanceOf(Tuple.class, (Tree)expression).map(Tuple::elements)).orElseGet(Collections::emptyList);
    }

    public static String unescape(StringLiteral stringLiteral) {
        List elements = stringLiteral.stringElements();
        if (elements.size() == 1) {
            return Expressions.unescape((StringElement)elements.get(0));
        }
        return elements.stream().map(Expressions::unescape).collect(Collectors.joining());
    }

    public static String unescape(StringElement stringElement) {
        boolean isBytesLiteral;
        String lowerCasePrefix = stringElement.prefix().toLowerCase(Locale.ROOT);
        String valueWithoutQuotes = stringElement.trimmedQuotesValue();
        boolean isEscaped = lowerCasePrefix.indexOf(114) == -1;
        boolean bl = isBytesLiteral = lowerCasePrefix.indexOf(98) != -1;
        if (isEscaped) {
            valueWithoutQuotes = Expressions.unescapeString(valueWithoutQuotes, isBytesLiteral);
        }
        return valueWithoutQuotes;
    }

    public static String unescapeString(String value, boolean isBytesLiteral) {
        if (value.indexOf(92) == -1) {
            return value;
        }
        int length = value.length();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = value.charAt(i);
            if (ch != '\\') {
                sb.append(ch);
                ++i;
                continue;
            }
            EscapeSequence escapeSequence = EscapeSequence.extract(value, i, isBytesLiteral);
            sb.append(escapeSequence.unescapedValue);
            i += escapeSequence.escapedLength;
        }
        return sb.toString();
    }

    public static Optional<Name> getAssignedName(Expression expression) {
        return Expressions.getAssignedName(expression, 0);
    }

    private static Optional<Name> getAssignedName(Expression expression, int recursionCount) {
        Tree maybeAssignment;
        if (recursionCount > 4) {
            return Optional.empty();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return Optional.of((Name)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return Optional.of(((QualifiedExpression)expression).name());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            expression = ((SubscriptionExpression)expression).object();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.SLICE_EXPR})) {
            expression = ((SliceExpression)expression).object();
        }
        if ((maybeAssignment = TreeUtils.firstAncestorOfKind((Tree)expression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) == null) {
            return Optional.empty();
        }
        AssignmentStatement assignment = (AssignmentStatement)maybeAssignment;
        List expressions = SymbolUtils.assignmentsLhs((AssignmentStatement)assignment);
        if (expressions.size() != 1) {
            List<Expression> rhsExpressions = Expressions.getExpressionsFromRhs(assignment.assignedValue());
            int rhsIndex = rhsExpressions.stream().flatMap(TreeUtils::flattenTuples).toList().indexOf(expression);
            if (rhsIndex != -1 && rhsIndex < expressions.size()) {
                return Expressions.getAssignedName((Expression)expressions.get(rhsIndex), recursionCount + 1);
            }
            return Optional.empty();
        }
        return Expressions.getAssignedName((Expression)expressions.get(0), recursionCount + 1);
    }

    public static List<Expression> getExpressionsFromRhs(Expression rhs) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (rhs.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            expressions.addAll(((Tuple)rhs).elements());
        } else if (rhs.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL})) {
            expressions.addAll(((ListLiteral)rhs).elements().expressions());
        } else if (rhs.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR})) {
            return Expressions.getExpressionsFromRhs(((UnpackingExpression)rhs).expression());
        }
        return expressions;
    }

    public static boolean isGenericTypeAnnotation(Expression expression) {
        return Optional.of(expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).map(Expressions::singleAssignedValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).map(CallExpression::callee).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter(TYPE_VAR_FQN::equals).isPresent();
    }

    public static boolean containsSpreadOperator(List<Argument> arguments) {
        return arguments.stream().anyMatch(UnpackingExpression.class::isInstance);
    }

    private static class EscapeSequence {
        private static final int HEXADECIMAL_RADIX = 16;
        private static final EscapeSequence IGNORE = new EscapeSequence(1, "\\");
        private static final char[] UNESCAPED_CHAR = new char[119];
        private final int escapedLength;
        private final String unescapedValue;

        private EscapeSequence(int escapedLength, String unescapedValue) {
            this.escapedLength = escapedLength;
            this.unescapedValue = unescapedValue;
        }

        private static EscapeSequence extract(String value, int i, boolean isBytesLiteral) {
            char unescaped;
            if (i == value.length() - 1) {
                return IGNORE;
            }
            char nextChar = value.charAt(i + 1);
            char c = unescaped = nextChar < UNESCAPED_CHAR.length ? UNESCAPED_CHAR[nextChar] : (char)'\u0000';
            if (unescaped != '\u0000') {
                return new EscapeSequence(2, String.valueOf(unescaped));
            }
            if (nextChar == '\n') {
                return new EscapeSequence(2, "");
            }
            if (nextChar == '\r') {
                return new EscapeSequence(i + 2 < value.length() && value.charAt(i + 2) == '\n' ? 3 : 2, "");
            }
            if (nextChar == 'x') {
                return EscapeSequence.extractHexadecimal(value, i, 2);
            }
            if (nextChar == 'u' && !isBytesLiteral) {
                return EscapeSequence.extractHexadecimal(value, i, 4);
            }
            if (nextChar == 'U' && !isBytesLiteral) {
                return EscapeSequence.extractHexadecimal(value, i, 8);
            }
            if (nextChar == 'N') {
                return IGNORE;
            }
            return EscapeSequence.extractOctal(value, i);
        }

        private static EscapeSequence extractHexadecimal(String value, int i, int length) {
            if (i + 1 + length < value.length()) {
                try {
                    int hexValue = Integer.parseInt(value.substring(i + 2, i + 2 + length), 16);
                    return new EscapeSequence(2 + length, String.valueOf((char)hexValue));
                }
                catch (NumberFormatException ex) {
                    return IGNORE;
                }
            }
            return IGNORE;
        }

        private static EscapeSequence extractOctal(String value, int i) {
            int j;
            int octal = 0;
            int octalStart = value.charAt(i + 1) == 'o' ? i + 2 : i + 1;
            int len = 0;
            for (j = octalStart; len < 3 && j < value.length() && value.charAt(j) >= '0' && value.charAt(j) <= '7'; ++j, ++len) {
                octal = octal * 8 + (value.charAt(j) - 48);
            }
            if (len > 0) {
                return new EscapeSequence(j - i, String.valueOf((char)octal));
            }
            return IGNORE;
        }

        static {
            EscapeSequence.UNESCAPED_CHAR[92] = 92;
            EscapeSequence.UNESCAPED_CHAR[39] = 39;
            EscapeSequence.UNESCAPED_CHAR[34] = 34;
            EscapeSequence.UNESCAPED_CHAR[97] = 7;
            EscapeSequence.UNESCAPED_CHAR[98] = 8;
            EscapeSequence.UNESCAPED_CHAR[102] = 12;
            EscapeSequence.UNESCAPED_CHAR[110] = 10;
            EscapeSequence.UNESCAPED_CHAR[114] = 13;
            EscapeSequence.UNESCAPED_CHAR[116] = 9;
            EscapeSequence.UNESCAPED_CHAR[118] = 11;
        }
    }
}

