/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S108";
    public static final String QUICK_FIX_MESSAGE = "Add a TODO comment";
    private static final String MESSAGE = "Either remove or fill this block of code.";
    private static final String TODO_COMMENT_TEXT = "# TODO: Add implementation";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            int to;
            StatementList statementListTree = (StatementList)ctx.syntaxNode();
            if (statementListTree.statements().stream().anyMatch(stmt -> !stmt.is(new Tree.Kind[]{Tree.Kind.PASS_STMT}))) {
                return;
            }
            Tree parent = statementListTree.parent();
            if (parent.is(new Tree.Kind[]{Tree.Kind.FUNCDEF}) || parent.is(new Tree.Kind[]{Tree.Kind.CLASSDEF}) || parent.is(new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE})) {
                return;
            }
            List parentTokens = TreeUtils.tokens((Tree)statementListTree.parent());
            int from = parentTokens.stream().filter(t -> t.type() == PythonTokenType.NEWLINE).findFirst().map(parentTokens::indexOf).orElseThrow(() -> new IllegalStateException(String.format("No newline token in parent of statement list at line %s", statementListTree.firstToken().line())));
            if (!EmptyNestedBlockCheck.containsComment(parentTokens.subList(from, to = parentTokens.indexOf(statementListTree.lastToken()) + 2))) {
                Tree passTreeElement = Optional.of(statementListTree).map(StatementList::statements).map(Collection::stream).flatMap(Stream::findFirst).map(Tree.class::cast).orElseGet(() -> ((StatementList)statementListTree).firstToken());
                PythonCheck.PreciseIssue issue = ctx.addIssue(passTreeElement, MESSAGE);
                if (passTreeElement.firstToken().line() != parent.firstToken().line()) {
                    PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.insertLineBefore((Tree)passTreeElement, (String)TODO_COMMENT_TEXT)});
                    issue.addQuickFix(quickFix);
                } else {
                    int indent = TreeUtils.findIndentationSize((Tree)passTreeElement);
                    if (indent > 0) {
                        int offset = parent.firstToken().column() + indent;
                        String textToInsert = "\n" + " ".repeat(offset) + "# TODO: Add implementation\n" + " ".repeat(offset);
                        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.insertBefore((Tree)passTreeElement, (String)textToInsert)});
                        issue.addQuickFix(quickFix);
                    }
                }
            }
        });
    }

    private static boolean containsComment(List<Token> tokens) {
        return tokens.stream().anyMatch(t -> !t.trivia().isEmpty());
    }
}

