/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ReturnCheckUtils;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2876")
public class IterMethodReturnTypeCheck
extends PythonSubscriptionCheck {
    private static final String INVALID_RETURN_VALUE_MESSAGE = "Return an object complying with iterator protocol.";
    private static final String NO_RETURN_STMTS_MESSAGE = "Return an object complying with iterator protocol. Consider explicitly raising a NotImplementedError if this class is not (yet) meant to support this method.";
    private static final String COROUTINE_METHOD_MESSAGE = "Return an object complying with iterator protocol. The method can not be a coroutine and have the `async` keyword.";
    private static final List<String> REQUIRED_ITERATOR_METHODS = List.of("__iter__", "__next__");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> IterMethodReturnTypeCheck.checkClassDefinition(ctx, (ClassDef)ctx.syntaxNode()));
    }

    private static void checkClassDefinition(SubscriptionContext ctx, ClassDef classDef) {
        for (FunctionDef methodDef : TreeUtils.topLevelFunctionDefs((ClassDef)classDef)) {
            IterMethodReturnTypeCheck.checkFunctionDefinition(ctx, classDef, methodDef, CheckUtils.mustBeAProtocolLike(classDef));
        }
    }

    private static void checkFunctionDefinition(SubscriptionContext ctx, ClassDef classDef, FunctionDef funDef, boolean classIsProtocolLike) {
        String funNameString = funDef.name().name();
        if (!"__iter__".equals(funNameString)) {
            return;
        }
        ReturnCheckUtils.addIssueIfAsync(ctx, funDef, COROUTINE_METHOD_MESSAGE);
        ReturnCheckUtils.ReturnStmtCollector returnStmtCollector = ReturnCheckUtils.ReturnStmtCollector.collect(funDef);
        if (returnStmtCollector.containsYield()) {
            return;
        }
        List<ReturnStatement> returnStmts = returnStmtCollector.getReturnStmts();
        if (returnStmts.isEmpty() && !returnStmtCollector.raisesExceptions() && !CheckUtils.isAbstract(funDef) && !classIsProtocolLike) {
            ctx.addIssue(funDef.defKeyword(), funDef.colon(), NO_RETURN_STMTS_MESSAGE);
            return;
        }
        for (ReturnStatement returnStmt : returnStmts) {
            IterMethodReturnTypeCheck.checkReturnStmt(ctx, classDef, funDef, returnStmt);
        }
    }

    private static void checkReturnStmt(SubscriptionContext ctx, ClassDef classDef, FunctionDef functionDef, ReturnStatement returnStmt) {
        ClassSymbol classSymbol;
        List returnedExpressions = returnStmt.expressions();
        if (returnedExpressions.isEmpty()) {
            ctx.addIssue(returnStmt.returnKeyword(), INVALID_RETURN_VALUE_MESSAGE);
            return;
        }
        if (IterMethodReturnTypeCheck.returnsJustSelf(functionDef, returnedExpressions) && (classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef)) != null) {
            if (REQUIRED_ITERATOR_METHODS.stream().anyMatch(method -> !classSymbol.canHaveMember(method))) {
                ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStmt, INVALID_RETURN_VALUE_MESSAGE);
            }
            return;
        }
        InferredType returnStmtType = returnStmt.returnValueType();
        if (REQUIRED_ITERATOR_METHODS.stream().anyMatch(method -> !returnStmtType.canHaveMember(method))) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStmt, INVALID_RETURN_VALUE_MESSAGE);
        }
    }

    private static boolean returnsJustSelf(FunctionDef funDef, List<Expression> returnedExpressions) {
        if (returnedExpressions.size() != 1) {
            return false;
        }
        Expression firstReturnedExpression = returnedExpressions.get(0);
        if (!CheckUtils.isSelf(firstReturnedExpression)) {
            return false;
        }
        Symbol returnedSelfSymbol = ((Name)firstReturnedExpression).symbol();
        if (returnedSelfSymbol == null) {
            return false;
        }
        Symbol selfParameterSymbol = CheckUtils.findFirstParameterSymbol(funDef);
        if (selfParameterSymbol == null) {
            return false;
        }
        return returnedSelfSymbol == selfParameterSymbol;
    }
}

