/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1871")
public class SameBranchCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Either merge this branch with the identical one on line \"%s\" or change one of the implementations.";
    private List<Tree> ignoreList;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.ignoreList = new ArrayList<Tree>();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            boolean hasElseClause;
            IfStatement ifStmt = (IfStatement)ctx.syntaxNode();
            if (this.ignoreList.contains(ifStmt)) {
                return;
            }
            boolean bl = hasElseClause = ifStmt.elseBranch() != null;
            if (hasElseClause && SameBranchCheck.allIdenticalBranches(ifStmt)) {
                return;
            }
            List<StatementList> branches = this.getIfBranches(ifStmt);
            SameBranchCheck.findSameBranches(branches, ctx);
        });
    }

    private static boolean allIdenticalBranches(IfStatement ifStmt) {
        StatementList body = ifStmt.body();
        for (IfStatement elifBranch : ifStmt.elifBranches()) {
            if (CheckUtils.areEquivalent((Tree)body, (Tree)elifBranch.body())) continue;
            return false;
        }
        return CheckUtils.areEquivalent((Tree)body, (Tree)ifStmt.elseBranch().body());
    }

    private static void findSameBranches(List<? extends Tree> branches, SubscriptionContext ctx) {
        for (int i = 1; i < branches.size(); ++i) {
            SameBranchCheck.checkBranches(branches, i, ctx);
        }
    }

    private static void checkBranches(List<? extends Tree> branches, int index, SubscriptionContext ctx) {
        Tree duplicateBlock = branches.get(index);
        boolean isOnASingleLine = SameBranchCheck.isOnASingleLine(duplicateBlock);
        ArrayList<Tree> equivalentBlocks = new ArrayList<Tree>();
        for (int j = 0; j < index; ++j) {
            boolean allBranchesIdentical;
            Tree originalBlock = branches.get(j);
            if (!CheckUtils.areEquivalent(originalBlock, duplicateBlock)) continue;
            equivalentBlocks.add(originalBlock);
            boolean bl = allBranchesIdentical = equivalentBlocks.size() == branches.size() - 1;
            if (!isOnASingleLine && !allBranchesIdentical) {
                int line = ((Token)TreeUtils.nonWhitespaceTokens((Tree)originalBlock).get(0)).line();
                String message = String.format(MESSAGE, line);
                List issueTokens = TreeUtils.nonWhitespaceTokens((Tree)duplicateBlock);
                ctx.addIssue((Token)issueTokens.get(0), (Token)issueTokens.get(issueTokens.size() - 1), message).secondary(SameBranchCheck.issueLocation(originalBlock, "Original"));
                break;
            }
            if (!allBranchesIdentical) continue;
            equivalentBlocks.add(duplicateBlock);
            Tree firstBlock = branches.get(0);
            int line = ((Token)TreeUtils.nonWhitespaceTokens((Tree)firstBlock).get(0)).line();
            String message = String.format(MESSAGE, line);
            equivalentBlocks.stream().skip(1L).forEach(e -> {
                List issueTokens = TreeUtils.nonWhitespaceTokens((Tree)e);
                ctx.addIssue((Token)issueTokens.get(0), (Token)issueTokens.get(issueTokens.size() - 1), message).secondary(SameBranchCheck.issueLocation(firstBlock, "Original"));
            });
        }
    }

    private static IssueLocation issueLocation(Tree body, String message) {
        List tokens = TreeUtils.nonWhitespaceTokens((Tree)body);
        return IssueLocation.preciseLocation((Token)((Token)tokens.get(0)), (Token)((Token)tokens.get(tokens.size() - 1)), (String)message);
    }

    private List<StatementList> getIfBranches(IfStatement ifStmt) {
        ArrayList<StatementList> branches = new ArrayList<StatementList>();
        branches.add(ifStmt.body());
        branches.addAll(ifStmt.elifBranches().stream().map(IfStatement::body).toList());
        ElseClause elseClause = ifStmt.elseBranch();
        if (elseClause != null) {
            branches.add(elseClause.body());
            this.lookForElseIfs(branches, elseClause);
        }
        return branches;
    }

    private void lookForElseIfs(List<StatementList> branches, ElseClause elseBranch) {
        IfStatement singleIfChild = SameBranchCheck.singleIfChild(elseBranch.body());
        if (singleIfChild != null) {
            this.ignoreList.add((Tree)singleIfChild);
            branches.addAll(this.getIfBranches(singleIfChild));
        }
    }

    private static IfStatement singleIfChild(StatementList statementList) {
        List statements = statementList.statements();
        if (statements.size() == 1 && ((Statement)statements.get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STMT})) {
            return (IfStatement)statements.get(0);
        }
        return null;
    }

    private static boolean isOnASingleLine(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STATEMENT_LIST})) {
            StatementList duplicateBlock = (StatementList)tree;
            return ((Statement)duplicateBlock.statements().get(0)).firstToken().line() == ((Statement)duplicateBlock.statements().get(duplicateBlock.statements().size() - 1)).lastToken().line();
        }
        return tree.firstToken().line() == tree.lastToken().line();
    }
}

