/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6327")
public class DisabledSNSTopicEncryptionCheck
extends AbstractCdkResourceCheck {
    private static final String OMITTING_MESSAGE = "Omitting \"%s\" disables SNS topics encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_sns.Topic", DisabledSNSTopicEncryptionCheck.checkTopic("master_key"));
        this.checkFqn("aws_cdk.aws_sns.CfnTopic", DisabledSNSTopicEncryptionCheck.checkTopic("kms_master_key_id"));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkTopic(String argMasterKeyName) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, argMasterKeyName).ifPresentOrElse(argMasterKey -> argMasterKey.addIssueIf(CdkPredicate.isNone(), DisabledSNSTopicEncryptionCheck.omittingMessage(argMasterKeyName), new IssueLocation[0]), () -> ctx.addIssue((Tree)callExpression.callee(), DisabledSNSTopicEncryptionCheck.omittingMessage(argMasterKeyName)));
    }

    private static String omittingMessage(String argName) {
        return String.format(OMITTING_MESSAGE, argName);
    }
}

