/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.UnrestrictedAdministrationCheckPartCfnSecurity;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6329")
public class PublicNetworkAccessToCloudResourcesCheck
extends AbstractCdkResourceCheck {
    public static final String PUBLICLY_ACCESSIBLE_ARG_NAME = "publicly_accessible";
    private static final String SUBNET_TYPE = "subnet_type";
    private static final String ASSOCIATE_PUBLIC_IP_ADDRESS = "associate_public_ip_address";
    private static final String MESSAGE = "Make sure allowing public network access is safe here.";
    private static final String SENSITIVE_SUBNET = "aws_cdk.aws_ec2.SubnetType.PUBLIC";
    private static final Set<String> SAFE_SUBNET_TYPES = Set.of("ISOLATED", "PRIVATE_ISOLATED", "PRIVATE", "PRIVATE_WITH_NAT");
    private static final Set<String> COMPLIANT_SUBNETS = Set.of("aws_cdk.aws_ec2.SubnetType.PRIVATE_ISOLATED", "aws_cdk.aws_ec2.SubnetType.PRIVATE_WITH_EGRESS", "aws_cdk.aws_ec2.SubnetType.PRIVATE_WITH_NAT");

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_dms.CfnReplicationInstance", (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, PUBLICLY_ACCESSIBLE_ARG_NAME).ifPresentOrElse(argument -> argument.addIssueIf(CdkPredicate.isTrue(), MESSAGE, new IssueLocation[0]), () -> subscriptionContext.addIssue((Tree)callExpression, MESSAGE)));
        this.checkFqn("aws_cdk.aws_rds.DatabaseInstance", PublicNetworkAccessToCloudResourcesCheck::checkDatabaseInstance);
        this.checkFqn("aws_cdk.aws_rds.CfnDBInstance", (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, PUBLICLY_ACCESSIBLE_ARG_NAME).ifPresent(argument -> argument.addIssueIf(CdkPredicate.isTrue(), MESSAGE, new IssueLocation[0])));
        this.checkFqn("aws_cdk.aws_ec2.Instance", PublicNetworkAccessToCloudResourcesCheck::checkInstance);
        this.checkFqn("aws_cdk.aws_ec2.CfnInstance", PublicNetworkAccessToCloudResourcesCheck::checkCfnInstance);
    }

    private static void checkInstance(SubscriptionContext ctx, CallExpression callExpression) {
        CdkUtils.getArgument(ctx, callExpression, "vpc_subnets").ifPresent(flow -> {
            PublicNetworkAccessToCloudResourcesCheck.checkVpcSubnetAsSensitiveSubnetSelectionCall(ctx, flow);
            PublicNetworkAccessToCloudResourcesCheck.checkVpcSubnetAsSensitiveDictionary(ctx, flow);
        });
    }

    private static void checkVpcSubnetAsSensitiveSubnetSelectionCall(SubscriptionContext ctx, CdkUtils.ExpressionFlow flow) {
        flow.getExpression(CdkPredicate.isFqn("aws_cdk.aws_ec2.SubnetSelection")).filter(expression -> expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})).map(CallExpression.class::cast).ifPresent(callExpression -> CdkUtils.getArgument(ctx, callExpression, SUBNET_TYPE).flatMap(flowArg -> flowArg.getExpression(CdkPredicate.isFqn(SENSITIVE_SUBNET))).ifPresent(expr -> ctx.addIssue(callExpression.parent(), MESSAGE)));
    }

    private static void checkVpcSubnetAsSensitiveDictionary(SubscriptionContext ctx, CdkUtils.ExpressionFlow flow) {
        CdkUtils.getDictionary(flow).flatMap(dictionary -> CdkUtils.getDictionaryPair(ctx, dictionary, SUBNET_TYPE)).flatMap(element -> element.value.getExpression(CdkPredicate.isFqn(SENSITIVE_SUBNET))).ifPresent(expression -> PublicNetworkAccessToCloudResourcesCheck.raiseIssueOnParent(ctx, expression, Tree.Kind.REGULAR_ARGUMENT));
    }

    private static void checkCfnInstance(SubscriptionContext ctx, CallExpression callExpression) {
        CdkUtils.getArgument(ctx, callExpression, "network_interfaces").flatMap(flow -> flow.getExpression(CdkPredicate.isListLiteral())).map(ListLiteral.class::cast).map(listLiteral -> listLiteral.elements().expressions()).orElse(Collections.emptyList()).forEach(expression -> {
            PublicNetworkAccessToCloudResourcesCheck.checkNetworkInterfacesCallExpression(ctx, expression);
            PublicNetworkAccessToCloudResourcesCheck.checkNetworkInterfacesDictionary(ctx, expression);
        });
    }

    private static void checkNetworkInterfacesCallExpression(SubscriptionContext ctx, Expression expression) {
        Optional.of(expression).filter(CdkPredicate.isCallExpression()).map(CallExpression.class::cast).filter(CdkPredicate.isFqn("aws_cdk.aws_ec2.CfnInstance.NetworkInterfaceProperty")).ifPresent(call -> PublicNetworkAccessToCloudResourcesCheck.checkSensitiveOptionWithoutCompliantSubnetDefined(ctx, call));
    }

    private static void checkSensitiveOptionWithoutCompliantSubnetDefined(SubscriptionContext ctx, CallExpression callExpression) {
        Optional<CdkUtils.ExpressionFlow> associatedPublicIpAddress = CdkUtils.getArgument(ctx, callExpression, ASSOCIATE_PUBLIC_IP_ADDRESS);
        Optional<CdkUtils.ExpressionFlow> subnetId = CdkUtils.getArgument(ctx, callExpression, "subnet_id");
        if (associatedPublicIpAddress.filter(flow -> flow.hasExpression(CdkPredicate.isTrue())).isPresent() && subnetId.filter(PublicNetworkAccessToCloudResourcesCheck::hasPrivateSubnetDefined).isEmpty()) {
            associatedPublicIpAddress.get().addIssue(MESSAGE, new IssueLocation[0]);
        }
    }

    private static void checkNetworkInterfacesDictionary(SubscriptionContext ctx, Expression expression) {
        CdkUtils.getDictionary(expression).map(dictionaryLiteral -> UnrestrictedAdministrationCheckPartCfnSecurity.DictionaryAsMap.build(ctx, dictionaryLiteral)).ifPresent(dictionaryAsMap -> {
            if (dictionaryAsMap.hasKeyValuePair(ASSOCIATE_PUBLIC_IP_ADDRESS, CdkPredicate.isTrue()) && dictionaryAsMap.getValue("subnet_id").filter(PublicNetworkAccessToCloudResourcesCheck::hasPrivateSubnetDefined).isEmpty()) {
                dictionaryAsMap.getKeyString(ASSOCIATE_PUBLIC_IP_ADDRESS).ifPresent(expr -> PublicNetworkAccessToCloudResourcesCheck.raiseIssueOnParent(ctx, expr, Tree.Kind.KEY_VALUE_PAIR));
            }
        });
    }

    private static boolean hasPrivateSubnetDefined(CdkUtils.ExpressionFlow subnetId) {
        return subnetId.getExpression(CdkPredicate.isSubscriptionExpression()).map(SubscriptionExpression.class::cast).map(SubscriptionExpression::object).filter(PublicNetworkAccessToCloudResourcesCheck::isCompliantSubnet).isPresent();
    }

    private static boolean isCompliantSubnet(Expression expression) {
        Optional<CallExpression> callExpression = PublicNetworkAccessToCloudResourcesCheck.getCallSelectSubnets(expression);
        return callExpression.flatMap(call -> CdkUtils.getArgument(null, call, SUBNET_TYPE)).filter(flow -> flow.hasExpression(CdkPredicate.isFqnOf(COMPLIANT_SUBNETS))).isPresent();
    }

    private static Optional<CallExpression> getCallSelectSubnets(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            Expression qualifier = ((QualifiedExpression)expression).qualifier();
            CdkUtils.ExpressionFlow flow = CdkUtils.ExpressionFlow.build(null, qualifier);
            return flow.getExpression(CdkPredicate.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_ec2.Vpc.select_subnets"))).map(CallExpression.class::cast);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            CdkUtils.ExpressionFlow flow = CdkUtils.ExpressionFlow.build(null, expression);
            return flow.getExpression(PublicNetworkAccessToCloudResourcesCheck.isQualifiedExpression()).map(QualifiedExpression.class::cast).map(qualifiedExpression -> CdkUtils.ExpressionFlow.build(null, qualifiedExpression.qualifier())).flatMap(flow2 -> flow2.getExpression(CdkPredicate.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_ec2.Vpc.select_subnets")))).map(CallExpression.class::cast);
        }
        return Optional.empty();
    }

    private static void raiseIssueOnParent(SubscriptionContext ctx, Expression expression, Tree.Kind kind) {
        ctx.addIssue(Optional.ofNullable(TreeUtils.firstAncestorOfKind((Tree)expression, (Tree.Kind[])new Tree.Kind[]{kind})).orElse((Tree)expression), MESSAGE);
    }

    private static void checkDatabaseInstance(SubscriptionContext ctx, CallExpression call) {
        Optional<CdkUtils.ExpressionFlow> vpcSubnets = CdkUtils.getArgument(ctx, call, "vpc_subnets");
        Optional subnetType = vpcSubnets.flatMap(flow -> flow.getExpression(CdkPredicate.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_ec2.SubnetSelection")))).map(CallExpression.class::cast).flatMap(subnetSelection -> CdkUtils.getArgument(ctx, subnetSelection, SUBNET_TYPE));
        if (subnetType.filter(PublicNetworkAccessToCloudResourcesCheck.isSafeSubnetSelection()).isPresent()) {
            return;
        }
        CdkUtils.getArgument(ctx, call, PUBLICLY_ACCESSIBLE_ARG_NAME).ifPresentOrElse(access -> access.addIssueIf(CdkPredicate.isTrue(), MESSAGE, new IssueLocation[0]), () -> subnetType.filter(PublicNetworkAccessToCloudResourcesCheck.isPublicSubnetSelection()).ifPresent(subnets -> subnets.addIssue(MESSAGE, new IssueLocation[0])));
    }

    private static Predicate<CdkUtils.ExpressionFlow> isSafeSubnetSelection() {
        return subnetType -> SAFE_SUBNET_TYPES.stream().anyMatch(safeType -> subnetType.hasExpression(CdkPredicate.isFqn("aws_cdk.aws_ec2.SubnetType." + safeType)));
    }

    private static Predicate<CdkUtils.ExpressionFlow> isPublicSubnetSelection() {
        return subnetType -> subnetType.hasExpression(CdkPredicate.isFqn(SENSITIVE_SUBNET));
    }

    private static Predicate<Expression> isQualifiedExpression() {
        return expression -> expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR});
    }
}

