/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6281")
public class S3BucketBlockPublicAccessCheck
extends AbstractS3BucketCheck {
    private static final String MESSAGE = "Make sure allowing public ACL/policies to be set is safe here.";
    private static final String OMITTING_MESSAGE = "No Public Access Block configuration prevents public ACL/policies to be set on this S3 bucket. Make sure it is safe here.";
    private static final String BLOCK_PUBLIC_ACCESS_FQN = "aws_cdk.aws_s3.BlockPublicAccess";
    private static final String BLOCK_ACLS_FQN = "aws_cdk.aws_s3.BlockPublicAccess.BLOCK_ACLS";
    private static final List<String> BLOCK_PUBLIC_ACCESS_ARGUMENTS = List.of("block_public_acls", "ignore_public_acls", "block_public_policy", "restrict_public_buckets");

    @Override
    BiConsumer<SubscriptionContext, CallExpression> visitBucketConstructor() {
        return (ctx, bucket) -> {
            Optional<CdkUtils.ExpressionFlow> blockPublicAccess = CdkUtils.getArgument(ctx, bucket, "block_public_access");
            if (blockPublicAccess.isPresent()) {
                S3BucketBlockPublicAccessCheck.checkBlockPublicAccess(ctx, blockPublicAccess.get());
            } else {
                ctx.addIssue((Tree)bucket.callee(), OMITTING_MESSAGE);
            }
        };
    }

    private static void checkBlockPublicAccess(SubscriptionContext ctx, CdkUtils.ExpressionFlow blockPublicAccess) {
        blockPublicAccess.addIssueIf(S3BucketBlockPublicAccessCheck::blocksAclsOnly, MESSAGE, new IssueLocation[0]);
        blockPublicAccess.locations().stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(S3BucketBlockPublicAccessCheck::isBlockPublicAccessConstructor).findAny().ifPresent(bpaConstructor -> S3BucketBlockPublicAccessCheck.visitBlockPublicAccessConstructor(ctx, bpaConstructor));
    }

    private static void visitBlockPublicAccessConstructor(SubscriptionContext ctx, CallExpression bpaConstructor) {
        BLOCK_PUBLIC_ACCESS_ARGUMENTS.stream().map(args -> CdkUtils.getArgument(ctx, bpaConstructor, args)).filter(Optional::isPresent).map(Optional::get).toList().forEach(flow -> flow.addIssueIf(CdkPredicate.isFalse(), MESSAGE, new IssueLocation[0]));
    }

    private static boolean blocksAclsOnly(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            return Optional.ofNullable(qualifiedExpression.symbol()).map(Symbol::fullyQualifiedName).filter(BLOCK_ACLS_FQN::equals).isPresent();
        }
        return false;
    }

    private static boolean isBlockPublicAccessConstructor(CallExpression expression) {
        return Optional.ofNullable(expression.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(BLOCK_PUBLIC_ACCESS_FQN::equals).isPresent();
    }
}

