/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S6262")
public class AwsHardcodedRegionCheck
extends PythonSubscriptionCheck {
    public static final String REGION_ARGUMENT_KEYWORD = "region_name";
    private static final String HARDCODED_REGION_ISSUE_MESSAGE = "AWS region should not be set with a hardcoded String";
    private static final Set<ClientMethod> AWS_CLIENT_METHODS = Set.of(new ClientMethod("boto3.client", 1), new ClientMethod("boto3.resource", 1), new ClientMethod("boto3.session.Session.client", 1), new ClientMethod("boto3.session.Session.resource", 1), new ClientMethod("boto3.session.Session", 3));
    private TypeCheckMap<ClientMethod> isClientWithRegionNameParameterCheckMap;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initializeCheck(SubscriptionContext ctx) {
        this.isClientWithRegionNameParameterCheckMap = new TypeCheckMap();
        AWS_CLIENT_METHODS.forEach(method -> this.isClientWithRegionNameParameterCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(method.fqn()), method));
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        this.checkSensitiveCall(callExpression).flatMap(sensitiveClientCall -> AwsHardcodedRegionCheck.getHarcodedRegionArgument(sensitiveClientCall, callExpression)).ifPresent(regularArgument -> ctx.addIssue((Tree)regularArgument, HARDCODED_REGION_ISSUE_MESSAGE));
    }

    private Optional<ClientMethod> checkSensitiveCall(CallExpression callExpression) {
        PythonType calleeType = TreeUtils.inferSingleAssignedExpressionType((Expression)callExpression.callee());
        return Optional.ofNullable((ClientMethod)this.isClientWithRegionNameParameterCheckMap.getForType(calleeType));
    }

    private static Optional<RegularArgument> getHarcodedRegionArgument(ClientMethod clientMethod, CallExpression callExpression) {
        return TreeUtils.nthArgumentOrKeywordOptional((int)clientMethod.regionNameArgIndex(), (String)REGION_ARGUMENT_KEYWORD, (List)callExpression.arguments()).filter(AwsHardcodedRegionCheck::isHardcodedArgument);
    }

    private static boolean isHardcodedArgument(RegularArgument regularArgument) {
        Optional<Expression> expression = Expressions.ifNameGetSingleAssignedNonNameValue(regularArgument.expression());
        return expression.isPresent() && expression.get().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    record ClientMethod(String fqn, int regionNameArgIndex) {
    }
}

