/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7497")
public class CancellationReraisedInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Ensure that the %s exception is re-raised after your cleanup code.";
    private static final String ASYNCIO_CANCELLED_ERROR = "asyncio.CancelledError";
    private static final String TRIO_CANCELLED = "trio.Cancelled";
    private static final String ANYIO_CANCELLED = "anyio.get_cancelled_exc_class";
    private static final String MESSAGE_SECONDARY = "This function is async.";
    private TypeCheckMap<String> cancelledExceptionTypeCheckMap;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeChecksForFile);
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, this::checkTryStatement);
    }

    private void initializeChecksForFile(SubscriptionContext ctx) {
        this.cancelledExceptionTypeCheckMap = new TypeCheckMap();
        this.cancelledExceptionTypeCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(ASYNCIO_CANCELLED_ERROR), (Object)ASYNCIO_CANCELLED_ERROR);
        this.cancelledExceptionTypeCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(TRIO_CANCELLED), (Object)TRIO_CANCELLED);
        this.cancelledExceptionTypeCheckMap.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(ANYIO_CANCELLED), (Object)"cancellation");
    }

    private void checkTryStatement(SubscriptionContext context) {
        TryStatement tryStatement = (TryStatement)context.syntaxNode();
        Token enclosingAsyncToken = TreeUtils.asyncTokenOfEnclosingFunction((Tree)tryStatement).orElse(null);
        if (enclosingAsyncToken == null) {
            return;
        }
        tryStatement.exceptClauses().forEach(exceptClause -> this.checkExceptClause(context, (ExceptClause)exceptClause, enclosingAsyncToken));
    }

    private void checkExceptClause(SubscriptionContext subscriptionContext, ExceptClause exceptClause, Token enclosingAsyncToken) {
        Expression exception = exceptClause.exception();
        if (exception == null) {
            return;
        }
        String isOffendingException = this.isOffendingException(exception);
        if (isOffendingException.isEmpty()) {
            return;
        }
        boolean isCompliant = true;
        boolean hasTopLevelPass = exceptClause.body().statements().stream().anyMatch(s -> s.is(new Tree.Kind[]{Tree.Kind.PASS_STMT}));
        if (hasTopLevelPass) {
            isCompliant = false;
        } else {
            ComplianceChecker complianceChecker = new ComplianceChecker(exceptClause);
            exceptClause.accept((TreeVisitor)complianceChecker);
            isCompliant = complianceChecker.isCompliant();
        }
        if (!isCompliant) {
            subscriptionContext.addIssue((Tree)exception, String.format(MESSAGE, isOffendingException)).secondary(enclosingAsyncToken, MESSAGE_SECONDARY);
        }
    }

    private String isOffendingException(Expression exception) {
        CallExpression callExpression;
        Optional result;
        Optional isOffendingTypeOpt = this.cancelledExceptionTypeCheckMap.getOptionalForType(exception.typeV2());
        if (isOffendingTypeOpt.isPresent()) {
            return (String)isOffendingTypeOpt.get();
        }
        if (exception instanceof CallExpression && (result = this.cancelledExceptionTypeCheckMap.getOptionalForType((callExpression = (CallExpression)exception).callee().typeV2())).isPresent()) {
            return (String)result.get();
        }
        return "";
    }

    static class ComplianceChecker
    extends BaseTreeVisitor {
        private final ExceptClause exceptClause;
        private boolean hasRaiseStatement = false;
        private boolean isCompliant = true;

        ComplianceChecker(ExceptClause exceptClause) {
            this.exceptClause = exceptClause;
        }

        boolean isCompliant() {
            return this.isCompliant && this.hasRaiseStatement;
        }

        private static boolean isReRaise(RaiseStatement raiseStatement, ExceptClause exceptClause) {
            boolean isBareRaise = raiseStatement.expressions().isEmpty();
            Optional exceptionInstanceName = TreeUtils.toOptionalInstanceOf(Name.class, (Tree)exceptClause.exceptionInstance());
            boolean isReRaise = raiseStatement.expressions().size() == 1 && exceptionInstanceName.isPresent() && ((Expression)raiseStatement.expressions().get(0)).is(new Tree.Kind[]{Tree.Kind.NAME}) && ((Name)raiseStatement.expressions().get(0)).name().equals(((Name)exceptionInstanceName.get()).name());
            return isBareRaise || isReRaise;
        }

        public void visitRaiseStatement(RaiseStatement raiseStatement) {
            this.hasRaiseStatement = true;
            if (!ComplianceChecker.isReRaise(raiseStatement, this.exceptClause)) {
                this.isCompliant = false;
                return;
            }
            super.visitRaiseStatement(raiseStatement);
        }

        public void visitReturnStatement(ReturnStatement returnStatement) {
            this.isCompliant = false;
        }

        protected void scan(@Nullable Tree tree) {
            if (!this.isCompliant) {
                return;
            }
            super.scan(tree);
        }
    }
}

