/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5719")
public class InstanceAndClassMethodsAtLeastOnePositionalCheck
extends PythonSubscriptionCheck {
    private static final List<String> KNOWN_CLASS_METHODS = Arrays.asList("__new__", "__init_subclass__");

    private static boolean isUsageInClassBody(Usage usage, ClassDef classDef) {
        return usage.kind() != Usage.Kind.FUNC_DECLARATION && classDef.equals(TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF}));
    }

    private static void handleFunctionDef(SubscriptionContext ctx, ClassDef classDef, FunctionDef functionDef) {
        List parameters = TreeUtils.positionalParameters((FunctionDef)functionDef);
        if (!parameters.isEmpty()) {
            return;
        }
        ClassSymbol classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef);
        if (classSymbol == null || classSymbol.isOrExtends("zope.interface.Interface")) {
            return;
        }
        FunctionSymbol functionSymbol = TreeUtils.getFunctionSymbolFromDef((FunctionDef)functionDef);
        if (functionSymbol == null || functionSymbol.usages().stream().anyMatch(usage -> InstanceAndClassMethodsAtLeastOnePositionalCheck.isUsageInClassBody(usage, classDef))) {
            return;
        }
        List<String> decoratorNames = functionDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression((Expression)decorator.expression())).filter(Objects::nonNull).toList();
        if (decoratorNames.contains("staticmethod") || decoratorNames.contains("abstractstaticmethod")) {
            return;
        }
        String name = functionSymbol.name();
        if (KNOWN_CLASS_METHODS.contains(name) || decoratorNames.contains("classmethod")) {
            InstanceAndClassMethodsAtLeastOnePositionalCheck.addIssue(ctx, functionDef, MethodIssueType.CLASS_METHOD);
        } else {
            InstanceAndClassMethodsAtLeastOnePositionalCheck.addIssue(ctx, functionDef, MethodIssueType.REGULAR_METHOD);
        }
    }

    private static void addIssue(SubscriptionContext ctx, FunctionDef functionDef, MethodIssueType type) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), type.message);
        String separator = functionDef.parameters() == null ? "" : ", ";
        for (String insertion : type.insertions) {
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)String.format("Add '%s' as the first parameter.", insertion)).addTextEdit(new PythonTextEdit[]{TextEditUtils.insertAfter((Tree)functionDef.leftPar(), (String)(insertion + separator))}).build();
            issue.addQuickFix(quickFix);
        }
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            TreeUtils.topLevelFunctionDefs((ClassDef)classDef).forEach(functionDef -> InstanceAndClassMethodsAtLeastOnePositionalCheck.handleFunctionDef(ctx, classDef, functionDef));
        });
    }

    private static enum MethodIssueType {
        CLASS_METHOD("Add a class parameter", "cls"),
        REGULAR_METHOD("Add a \"self\" or class parameter", "cls", "self");

        private final String message;
        private final List<String> insertions;

        private MethodIssueType(String message, String ... insertions) {
            this.message = message;
            this.insertions = Arrays.asList(insertions);
        }
    }
}

