/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S113")
public class MissingNewlineAtEndOfFileCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a new line at the end of this file \"%s\".";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            String fileContent = ctx.pythonFile().content();
            if (!(fileContent.isEmpty() || fileContent.endsWith("\n") || fileContent.endsWith("\r"))) {
                ctx.addFileIssue(String.format(MESSAGE, ctx.pythonFile().fileName()));
            }
        });
    }
}

