/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.IsComprehensionTransformedChecker;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7494")
public class RewriteCollectionConstructorAsComprehensionCheck
extends PythonSubscriptionCheck {
    private static final Map<String, String> COLLECTION_MESSAGES = Map.of("list", "Replace list constructor call with a list comprehension.", "set", "Replace set constructor call with a set comprehension.", "dict", "Replace dict constructor call with a dictionary comprehension.");
    private TypeCheckMap<String> collectionTypeCheckerMap = null;
    private TypeCheckBuilder tupleTypeCheck = null;
    private TypeCheckBuilder dictTypeCheck = null;
    private IsComprehensionTransformedChecker isComprehensionTransformedChecker = null;

    public void initialize(SubscriptionCheck.Context context) {
        this.isComprehensionTransformedChecker = new IsComprehensionTransformedChecker(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void initTypeChecks(SubscriptionContext ctx) {
        this.collectionTypeCheckerMap = new TypeCheckMap();
        for (Map.Entry<String, String> collectionEntry : COLLECTION_MESSAGES.entrySet()) {
            TypeCheckBuilder typeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(collectionEntry.getKey());
            this.collectionTypeCheckerMap.put(typeChecker, (Object)collectionEntry.getValue());
        }
        this.tupleTypeCheck = ctx.typeChecker().typeCheckBuilder().isInstanceOf("tuple");
        this.dictTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("dict");
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        List arguments = callExpression.arguments();
        String message = this.getMessageForConstructor(callExpression).orElse(null);
        if (message == null) {
            return;
        }
        ComprehensionExpression generator = RewriteCollectionConstructorAsComprehensionCheck.getSingleGeneratorArg(arguments).orElse(null);
        if (generator == null || this.isDictCallWithTuplesResultGenerator(callExpression, generator)) {
            return;
        }
        if (this.isComprehensionTransformedChecker.isGeneratorTransformingData(generator, callExpression.callee().typeV2())) {
            ctx.addIssue((Tree)callExpression.callee(), message);
        }
    }

    private boolean isDictCallWithTuplesResultGenerator(CallExpression callExpression, ComprehensionExpression generatorArgument) {
        return this.dictTypeCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE && this.isCallReturningTuple(generatorArgument.resultExpression());
    }

    private boolean isCallReturningTuple(Expression expression) {
        CallExpression callExpression;
        return expression instanceof CallExpression && this.tupleTypeCheck.check((callExpression = (CallExpression)expression).typeV2()) == TriBool.TRUE;
    }

    private Optional<String> getMessageForConstructor(CallExpression callExpression) {
        return this.collectionTypeCheckerMap.getOptionalForType(callExpression.callee().typeV2());
    }

    private static Optional<ComprehensionExpression> getSingleGeneratorArg(List<Argument> arguments) {
        if (arguments.size() != 1) {
            return Optional.empty();
        }
        Argument argument = arguments.get(0);
        if (!(argument instanceof RegularArgument)) {
            return Optional.empty();
        }
        RegularArgument regularArg = (RegularArgument)argument;
        Expression argument2 = regularArg.expression();
        if (!argument2.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
            return Optional.empty();
        }
        return Optional.of((ComprehensionExpression)argument2);
    }
}

