/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.AbstractStringFormatCheck;
import org.sonar.python.checks.StringFormat;

@Rule(key="S2275")
public class StringFormatMisuseCheck
extends AbstractStringFormatCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.MODULO, this::checkPrintfStyle);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkStrFormatStyle);
    }

    @Override
    protected void checkPrintfStyle(SubscriptionContext ctx, BinaryExpression modulo, StringLiteral literal) {
        Optional<StringFormat> formatOptional = StringFormat.createFromPrintfStyle(StringFormatMisuseCheck.syntaxIssueReporter(ctx, (Tree)modulo.leftOperand(), (Tree)literal), literal.trimmedQuotesValue());
        if (!formatOptional.isPresent()) {
            return;
        }
        StringFormat format = formatOptional.get();
        Expression rhs = modulo.rightOperand();
        if (format.numExpectedArguments() == 0L) {
            if (!StringFormatMisuseCheck.isMapping(rhs) && !rhs.type().canOnlyBe("list")) {
                StringFormatMisuseCheck.reportIssue(ctx, (Tree)modulo.leftOperand(), (Tree)literal, "Add replacement field(s) to this formatted string.");
            }
            return;
        }
        if (format.hasNamedFields()) {
            StringFormatMisuseCheck.checkNamed(ctx, format, rhs);
        } else {
            StringFormatMisuseCheck.checkPositional(ctx, format, rhs);
        }
    }

    @Override
    protected void checkStrFormatStyle(SubscriptionContext ctx, CallExpression callExpression, Expression qualifier, StringLiteral literal) {
        if (callExpression.arguments().stream().anyMatch(argument -> !argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT}))) {
            return;
        }
        Optional<StringFormat> format = StringFormat.createFromStrFormatStyle(StringFormatMisuseCheck.syntaxIssueReporter(ctx, (Tree)qualifier, (Tree)literal), literal.trimmedQuotesValue());
        if (!format.isPresent()) {
            return;
        }
        List<RegularArgument> arguments = callExpression.arguments().stream().map(RegularArgument.class::cast).toList();
        OptionalInt firstKwIdx = IntStream.range(0, arguments.size()).filter(idx -> ((RegularArgument)arguments.get(idx)).keywordArgument() != null).findFirst();
        HashSet kwArguments = new HashSet();
        if (firstKwIdx.isPresent()) {
            arguments.subList(firstKwIdx.getAsInt(), arguments.size()).forEach(argument -> kwArguments.add(argument.keywordArgument().name()));
        }
        format.get().replacementFields().stream().filter(field -> field.isNamed() && !kwArguments.contains(field.name())).forEach(field -> StringFormatMisuseCheck.reportIssue(ctx, (Tree)qualifier, (Tree)literal, String.format("Provide a value for field \"%s\".", field.name())));
        int firstIdx = firstKwIdx.orElse(arguments.size());
        String unmatchedPositionals = format.get().replacementFields().stream().filter(field -> field.isPositional() && field.position() >= firstIdx).map(field -> String.valueOf(field.position())).distinct().collect(Collectors.joining(", "));
        if (!unmatchedPositionals.isEmpty()) {
            StringFormatMisuseCheck.reportIssue(ctx, (Tree)qualifier, (Tree)literal, String.format("Provide a value for field(s) with index %s.", unmatchedPositionals));
        }
    }

    private static void checkNamed(SubscriptionContext ctx, StringFormat format, Expression rhs) {
        if (rhs.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            StringFormatMisuseCheck.checkPrintfDictionary(ctx, format, (DictionaryLiteral)rhs);
        } else if (!StringFormatMisuseCheck.isMapping(rhs)) {
            ctx.addIssue((Tree)rhs, "Replace this formatting argument with a mapping.");
        }
    }

    private static void checkPositional(SubscriptionContext ctx, StringFormat format, Expression rhs) {
        if (rhs.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
            StringFormatMisuseCheck.checkTuples(ctx, format, (Tuple)rhs);
        } else if (format.numExpectedArguments() == 1L) {
            format.replacementFields().get(0).validateArgument(ctx, rhs);
        } else if (!rhs.type().canBeOrExtend("tuple")) {
            ctx.addIssue((Tree)rhs, "Replace this formatting argument with a tuple.");
        }
    }

    private static void checkTuples(SubscriptionContext ctx, StringFormat format, Tuple tuple) {
        if (tuple.elements().stream().anyMatch(expression -> expression.is(new Tree.Kind[]{Tree.Kind.UNPACKING_EXPR}))) {
            return;
        }
        StringFormatMisuseCheck.checkPrintfExpressionList(ctx, format, tuple.firstToken(), tuple.lastToken(), tuple.elements());
    }
}

