/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6925")
public class TfGatherDeprecatedValidateIndicesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't set the `validate_indices` argument, it is deprecated.";
    private static final String FQN = "tensorflow.gather";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, TfGatherDeprecatedValidateIndicesCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext context) {
        Optional.ofNullable(((CallExpression)context.syntaxNode()).calleeSymbol()).filter(symbol -> FQN.equals(symbol.fullyQualifiedName())).map(callExpression -> TreeUtils.nthArgumentOrKeyword((int)2, (String)"validate_indices", (List)((CallExpression)context.syntaxNode()).arguments())).ifPresent(argument -> context.addIssue((Tree)argument, MESSAGE));
    }
}

