/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S6903")
public class TimezoneNaiveDatetimeConstructorsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't use `%s` to create this datetime object.";
    private static final Set<String> NON_COMPLIANT_FQNS = Set.of("datetime.datetime.utcnow", "datetime.datetime.utcfromtimestamp");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, TimezoneNaiveDatetimeConstructorsCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return;
        }
        String fullyQualifiedName = calleeSymbol.fullyQualifiedName();
        if (fullyQualifiedName == null || !NON_COMPLIANT_FQNS.contains(fullyQualifiedName)) {
            return;
        }
        context.addIssue((Tree)callExpression, String.format(MESSAGE, fullyQualifiedName));
    }
}

