/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S1135")
public class ToDoCommentCheck
extends PythonSubscriptionCheck {
    private static final String TODO_COMMENT_PATTERN = "^#\\s*(?:TODO|todo|Todo)(?!\\w).*";
    private static final String MESSAGE = "Complete the task associated to this \"TODO\" comment.";

    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(TODO_COMMENT_PATTERN);
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                String comment = trivia.value();
                if (!pattern.matcher(comment).matches()) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
        });
    }
}

