/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7505")
public class UnnecessaryLambdaMapCallCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isMapTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isMapTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("map");
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.isMapCall(callExpression)) {
            TreeUtils.nthArgumentOrKeywordOptional((int)0, (String)"", (List)callExpression.arguments()).map(RegularArgument::expression).ifPresent(argumentExpression -> {
                if (UnnecessaryLambdaMapCallCheck.isLambda(argumentExpression) || UnnecessaryLambdaMapCallCheck.isAssignedToLambda(argumentExpression)) {
                    ctx.addIssue((Tree)callExpression, "Replace this map call with a comprehension.");
                }
            });
        }
    }

    private boolean isMapCall(CallExpression callExpression) {
        return this.isMapTypeCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private static boolean isLambda(@Nullable Expression argumentExpression) {
        return argumentExpression instanceof LambdaExpression;
    }

    private static boolean isAssignedToLambda(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && UnnecessaryLambdaMapCallCheck.getUsageCount(name = (Name)argumentExpression) == 2 && UnnecessaryLambdaMapCallCheck.isLambda(Expressions.singleAssignedValue(name));
    }

    private static int getUsageCount(Name name) {
        return Optional.ofNullable(name.symbolV2()).map(SymbolV2::usages).map(List::size).orElse(0);
    }
}

