/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6249")
public class S3BucketHTTPCommunicationCheck
extends AbstractS3BucketCheck {
    private static final String MESSAGE_NO_POLICY = "No bucket policy enforces HTTPS-only access to this bucket. Make sure it is safe here.";
    private static final String MESSAGE_HTTP_ALLOWED = "Make sure authorizing HTTP requests is safe here.";
    private static final String POLICY_STATEMENT_FQN = "aws_cdk.aws_iam.PolicyStatement";

    @Override
    BiConsumer<SubscriptionContext, CallExpression> visitBucketConstructor() {
        return S3BucketHTTPCommunicationCheck::checkBucketConstructor;
    }

    private static void checkBucketConstructor(SubscriptionContext ctx, CallExpression bucketConstructorCall) {
        Optional<CdkUtils.ExpressionFlow> enforceSslArg = CdkUtils.getArgument(ctx, bucketConstructorCall, "enforce_ssl");
        if (enforceSslArg.isEmpty()) {
            S3BucketHTTPCommunicationCheck.getBucketPolicy(bucketConstructorCall).flatMap(S3BucketHTTPCommunicationCheck::getPolicyStatementConstructor).ifPresentOrElse(policyStatementConstructorCall -> S3BucketHTTPCommunicationCheck.visitPolicyStatement(ctx, policyStatementConstructorCall), () -> ctx.addIssue((Tree)bucketConstructorCall.callee(), MESSAGE_NO_POLICY));
        } else {
            enforceSslArg.get().addIssueIf(CdkPredicate.isFalse(), MESSAGE_HTTP_ALLOWED, bucketConstructorCall);
        }
    }

    private static Optional<CallExpression> getBucketPolicy(CallExpression bucketConstructor) {
        return Optional.ofNullable(TreeUtils.firstAncestorOfKind((Tree)bucketConstructor, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})).flatMap(TreeUtils.toOptionalInstanceOfMapper(AssignmentStatement.class)).flatMap(S3BucketHTTPCommunicationCheck::getFirstAndOnlyAssignedVariable).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).flatMap(S3BucketHTTPCommunicationCheck::getAddToResourcePolicyCall);
    }

    private static Optional<Expression> getFirstAndOnlyAssignedVariable(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().filter(lhs -> lhs.expressions().size() == 1).map(lhs -> (Expression)lhs.expressions().get(0)).findFirst();
    }

    private static Optional<CallExpression> getAddToResourcePolicyCall(Name variableName) {
        Optional symbol = TreeUtils.getSymbolFromTree((Tree)variableName);
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        return ((Symbol)symbol.get()).usages().stream().filter(usage -> usage.kind() != Usage.Kind.ASSIGNMENT_LHS).map(usage -> usage.tree().parent()).flatMap(TreeUtils.toStreamInstanceOfMapper(QualifiedExpression.class)).filter(qualifiedExpr -> CdkPredicate.isFqn("add_to_resource_policy").test((Expression)qualifiedExpr.name())).map(Tree::parent).flatMap(TreeUtils.toStreamInstanceOfMapper(CallExpression.class)).findFirst();
    }

    private static Optional<CallExpression> getPolicyStatementConstructor(CallExpression addResourceToPolicyCall) {
        if (!addResourceToPolicyCall.arguments().isEmpty()) {
            return Optional.of((Argument)addResourceToPolicyCall.arguments().get(0)).flatMap(TreeUtils.toOptionalInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).filter(CdkPredicate.isFqn(POLICY_STATEMENT_FQN)::test);
        }
        return Optional.empty();
    }

    private static void visitPolicyStatement(SubscriptionContext ctx, CallExpression policyStatementConstructorCall) {
        if (!S3BucketHTTPCommunicationCheck.isPolicyCompliantForHttpsDeny(ctx, policyStatementConstructorCall)) {
            ctx.addIssue((Tree)policyStatementConstructorCall.callee(), MESSAGE_HTTP_ALLOWED);
        }
    }

    private static boolean isPolicyCompliantForHttpsDeny(SubscriptionContext ctx, CallExpression policyStatementConstructorCall) {
        boolean hasDenyEffect = S3BucketHTTPCommunicationCheck.hasArgumentWithFqn(ctx, policyStatementConstructorCall, "effect", "aws_cdk.aws_iam.Effect.DENY");
        boolean hasWildcardResources = S3BucketHTTPCommunicationCheck.argumentListContainsExpectedValue(ctx, policyStatementConstructorCall, "resources", "*");
        boolean hasWildcardActions = S3BucketHTTPCommunicationCheck.argumentListContainsExpectedValue(ctx, policyStatementConstructorCall, "actions", "s3:*");
        boolean hasWildcardPrincipals = S3BucketHTTPCommunicationCheck.argumentListContainsExpectedValue(ctx, policyStatementConstructorCall, "principals", "*");
        boolean hasSecureTransportCondition = S3BucketHTTPCommunicationCheck.argumentListContainsExpectedValue(ctx, policyStatementConstructorCall, "conditions", "SecureTransport:False");
        return hasDenyEffect && hasWildcardResources && hasWildcardActions && hasWildcardPrincipals && hasSecureTransportCondition;
    }

    private static boolean hasArgumentWithFqn(SubscriptionContext ctx, CallExpression call, String argName, String expectedFqn) {
        return CdkUtils.getArgument(ctx, call, argName).map(flow -> flow.hasExpression(CdkPredicate.isFqn(expectedFqn))).orElse(false);
    }

    private static boolean argumentListContainsExpectedValue(SubscriptionContext ctx, CallExpression call, String argName, String expectedValue) {
        return CdkUtils.getArgument(ctx, call, argName).flatMap(flow -> flow.getExpression(e -> e.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}))).map(ListLiteral.class::cast).map(list -> list.elements().expressions().stream().anyMatch(expr -> CdkUtils.getString(expr).filter(expectedValue::equals).isPresent())).orElse(false);
    }
}

