/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.django;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6553")
public class DjangoModelStringFieldCheck
extends PythonSubscriptionCheck {
    private static final String REPLACE_MESSAGE = "Replace this \"null=True\" flag with \"blank=True\".";
    private static final String REMOVE_MESSAGE = "Remove this \"null=True\" flag.";
    private static final String REPLACE_QUICK_FIX_MESSAGE = "Replace with \"blank=True\"";
    private static final String REMOVE_QUICK_FIX_MESSAGE = "Remove the \"null=true\" flag";
    private static final String DJANGO_MODEL_FQN = "django.db.models.Model";
    public static final Set<String> FIELD_TYPES_FQN = Set.of("django.db.models.CharField", "django.db.models.TextField");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            if (TreeUtils.getParentClassesFQN((ClassDef)classDef).contains(DJANGO_MODEL_FQN)) {
                List modelClassBodyStatements = classDef.body().statements();
                if (DjangoModelStringFieldCheck.isNotManaged(modelClassBodyStatements)) {
                    return;
                }
                modelClassBodyStatements.stream().filter(AssignmentStatement.class::isInstance).map(AssignmentStatement.class::cast).map(AssignmentStatement::assignedValue).filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(DjangoModelStringFieldCheck::isTextField).forEach(call -> DjangoModelStringFieldCheck.validateTextFieldArguments(ctx, call));
            }
        });
    }

    private static boolean isNotManaged(List<Statement> modelClassBodyStatements) {
        return modelClassBodyStatements.stream().filter(ClassDef.class::isInstance).map(ClassDef.class::cast).filter(cd -> "Meta".equals(cd.name().name())).map(ClassDef::body).map(StatementList::statements).flatMap(Collection::stream).filter(AssignmentStatement.class::isInstance).map(AssignmentStatement.class::cast).filter(DjangoModelStringFieldCheck::isManagedFieldAssignment).map(AssignmentStatement::assignedValue).filter(Name.class::isInstance).map(Name.class::cast).map(Name::name).anyMatch("False"::equals);
    }

    private static boolean isManagedFieldAssignment(AssignmentStatement fieldAssignment) {
        return fieldAssignment.lhsExpressions().stream().map(lhs -> TreeUtils.firstChild((Tree)lhs, Name.class::isInstance).map(Name.class::cast).orElse(null)).filter(Objects::nonNull).map(Name::name).anyMatch("managed"::equals);
    }

    private static boolean isTextField(CallExpression call) {
        return Optional.of(call).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter(FIELD_TYPES_FQN::contains).isPresent();
    }

    private static void validateTextFieldArguments(SubscriptionContext ctx, CallExpression call) {
        Optional<RegularArgument> nullArg = DjangoModelStringFieldCheck.getCallArgumentByName(call, "null").filter(DjangoModelStringFieldCheck::isArgumentSetAsTrue);
        Optional<RegularArgument> blankArg = DjangoModelStringFieldCheck.getCallArgumentByName(call, "blank").filter(DjangoModelStringFieldCheck::isArgumentSetAsTrue);
        Optional<RegularArgument> uniqueArg = DjangoModelStringFieldCheck.getCallArgumentByName(call, "unique").filter(DjangoModelStringFieldCheck::isArgumentSetAsTrue);
        if (blankArg.isPresent() && uniqueArg.isPresent()) {
            return;
        }
        nullArg.ifPresent(arg -> {
            if (blankArg.isPresent()) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)arg, REMOVE_MESSAGE);
                DjangoModelStringFieldCheck.createRemoveArgQuickFix(call, (Tree)arg).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
            } else {
                ctx.addIssue((Tree)arg, REPLACE_MESSAGE).addQuickFix(PythonQuickFix.newQuickFix((String)REPLACE_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.replace((Tree)arg, (String)"blank=True")}));
            }
        });
    }

    private static Optional<RegularArgument> getCallArgumentByName(CallExpression call, String name) {
        return call.arguments().stream().filter(RegularArgument.class::isInstance).map(RegularArgument.class::cast).filter(arg -> Objects.nonNull(arg.keywordArgument())).filter(arg -> Optional.of(arg).map(RegularArgument::keywordArgument).map(Name::name).filter(name::equals).isPresent()).findFirst();
    }

    private static boolean isArgumentSetAsTrue(RegularArgument arg) {
        return Optional.of(arg).map(RegularArgument::expression).filter(TreeUtils::isBooleanLiteral).filter(Name.class::isInstance).map(Name.class::cast).map(Name::name).filter("True"::equals).isPresent();
    }

    private static Optional<PythonQuickFix> createRemoveArgQuickFix(CallExpression call, Tree arg) {
        return Optional.ofNullable(call.argumentList()).map(Tree::children).map(args -> {
            Object removeTo;
            int count = args.size();
            int index = args.indexOf(arg);
            Tree removeFrom = arg;
            if (index == 0) {
                removeTo = (Tree)args.get(index + 2);
            } else {
                removeFrom = (Tree)args.get(index - 1);
                removeTo = index == count - 1 ? call.rightPar() : (Tree)args.get(index + 1);
            }
            return TextEditUtils.removeUntil((Tree)removeFrom, (Tree)removeTo);
        }).map(textEdit -> PythonQuickFix.newQuickFix((String)REMOVE_QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{textEdit}));
    }
}

