/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AwaitExpression;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7484")
public class BusyWaitingInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Refactor this loop to use an `Event` instead of polling with `sleep`.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String POLLING_MESSAGE = "Polling happens here.";
    private TypeCheckMap<Object> asyncSleepTypeChecks;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckMap);
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, this::checkWhileStatement);
    }

    private void initializeTypeCheckMap(SubscriptionContext ctx) {
        Object object = new Object();
        this.asyncSleepTypeChecks = new TypeCheckMap();
        this.asyncSleepTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("asyncio.sleep"), object);
        this.asyncSleepTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("trio.sleep"), object);
        this.asyncSleepTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("anyio.sleep"), object);
    }

    private void checkWhileStatement(SubscriptionContext ctx) {
        WhileStatement whileStmt = (WhileStatement)ctx.syntaxNode();
        FunctionDef enclosingFuncDef = (FunctionDef)TreeUtils.firstAncestorOfKind((Tree)whileStmt, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
        Optional<Token> asyncToken = Optional.ofNullable(enclosingFuncDef).map(FunctionDef::asyncKeyword);
        if (asyncToken.isEmpty()) {
            return;
        }
        SleepCallFinder sleepFinder = new SleepCallFinder(this.asyncSleepTypeChecks);
        whileStmt.body().accept((TreeVisitor)sleepFinder);
        if (sleepFinder.sleepAwait == null) {
            return;
        }
        GlobalOrNonLocalNameFinder conditionChecker = new GlobalOrNonLocalNameFinder(enclosingFuncDef);
        whileStmt.condition().accept((TreeVisitor)conditionChecker);
        if (conditionChecker.foundGlobalOrNonLocal) {
            ctx.addIssue((Tree)whileStmt.condition(), MESSAGE).secondary(sleepFinder.sleepAwait, POLLING_MESSAGE).secondary(asyncToken.get(), SECONDARY_MESSAGE);
        }
    }

    private static class SleepCallFinder
    extends BaseTreeVisitor {
        Tree sleepAwait = null;
        private final TypeCheckMap<Object> asyncSleepTypeChecks;

        SleepCallFinder(TypeCheckMap<Object> asyncSleepTypeChecks) {
            this.asyncSleepTypeChecks = asyncSleepTypeChecks;
        }

        public void visitAwaitExpression(AwaitExpression awaitExpr) {
            CallExpression callExpr;
            Expression expr = awaitExpr.expression();
            if (expr instanceof CallExpression && this.isAsyncSleepCall((callExpr = (CallExpression)expr).callee())) {
                this.sleepAwait = awaitExpr.awaitToken();
            }
            super.visitAwaitExpression(awaitExpr);
        }

        protected void scan(@Nullable Tree tree) {
            if (this.sleepAwait != null) {
                return;
            }
            super.scan(tree);
        }

        private boolean isAsyncSleepCall(Expression call) {
            return this.asyncSleepTypeChecks.getOptionalForType(call.typeV2()).isPresent();
        }
    }

    private static class GlobalOrNonLocalNameFinder
    extends BaseTreeVisitor {
        boolean foundGlobalOrNonLocal = false;
        private final FunctionDef whileLoopFunction;

        GlobalOrNonLocalNameFinder(FunctionDef whileLoopFunction) {
            this.whileLoopFunction = whileLoopFunction;
        }

        public void visitName(Name name) {
            if (this.foundGlobalOrNonLocal) {
                return;
            }
            Symbol symbol = name.symbol();
            if (symbol != null && GlobalOrNonLocalNameFinder.isSymbolDeclaredInOuterScope(symbol, this.whileLoopFunction)) {
                this.foundGlobalOrNonLocal = true;
            }
            super.visitName(name);
        }

        private static boolean isSymbolDeclaredInOuterScope(Symbol symbol, FunctionDef currentFunctionContext) {
            FileInput fileInput = (FileInput)TreeUtils.firstAncestorOfKind((Tree)currentFunctionContext, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FILE_INPUT});
            for (Usage usage : symbol.usages()) {
                if (usage.kind() != Usage.Kind.ASSIGNMENT_LHS) continue;
                if (fileInput.globalVariables().contains(symbol)) {
                    return true;
                }
                FunctionDef currentFunction = (FunctionDef)TreeUtils.firstAncestorOfKind((Tree)currentFunctionContext, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
                while (currentFunction != null) {
                    if (currentFunction.localVariables().contains(symbol)) {
                        return true;
                    }
                    currentFunction = (FunctionDef)TreeUtils.firstAncestorOfKind((Tree)currentFunction, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
                }
            }
            return false;
        }
    }
}

