/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S7506")
public class DictionaryStaticKeyCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, ctx -> {
            DictCompExpression dictCompExpression = (DictCompExpression)ctx.syntaxNode();
            Expression keyExpression = dictCompExpression.keyExpression();
            if (DictionaryStaticKeyCheck.isLiteralDictKey(keyExpression) || DictionaryStaticKeyCheck.isAssignedFromLiteralDictKey(keyExpression)) {
                ctx.addIssue((Tree)keyExpression, "Don't use a static key in a dictionary comprehension.");
            }
        });
    }

    private static boolean isLiteralDictKey(Expression expression) {
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            return !DictionaryStaticKeyCheck.isFString(stringLiteral);
        }
        return false;
    }

    private static boolean isAssignedFromLiteralDictKey(Expression expression) {
        return Expressions.ifNameGetSingleAssignedNonNameValue(expression).map(TreeUtils.toInstanceOfMapper(StringLiteral.class)).filter(Predicate.not(DictionaryStaticKeyCheck::isFString)).isPresent();
    }

    private static boolean isFString(StringLiteral stringLiteral) {
        return stringLiteral.stringElements().stream().anyMatch(StringElement::isInterpolated);
    }
}

