/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public abstract class ItemOperationsType
extends PythonSubscriptionCheck {
    static final String SECONDARY_MESSAGE = "Definition of \"%s\".";
    static final String DEFAULT_SECONDARY_MESSAGE = "Type definition.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.SUBSCRIPTION, this::checkSubscription);
    }

    private void checkSubscription(SubscriptionContext ctx) {
        SubscriptionExpression subscriptionExpression = (SubscriptionExpression)ctx.syntaxNode();
        if (ItemOperationsType.isWithinTypeAnnotation(subscriptionExpression) || ItemOperationsType.isTypeSubscription(subscriptionExpression.object())) {
            return;
        }
        HashMap<LocationInFile, String> secondaries = new HashMap<LocationInFile, String>();
        Expression subscriptionObject = subscriptionExpression.object();
        if (ItemOperationsType.isWithinDelStatement(subscriptionExpression)) {
            if (!this.isValidSubscription(subscriptionObject, "__delitem__", null, secondaries)) {
                this.reportIssue(subscriptionExpression, subscriptionObject, "__delitem__", ctx, secondaries);
            }
            return;
        }
        if (ItemOperationsType.isWithinAssignment(subscriptionExpression)) {
            if (!this.isValidSubscription(subscriptionObject, "__setitem__", null, secondaries)) {
                this.reportIssue(subscriptionExpression, subscriptionObject, "__setitem__", ctx, secondaries);
            }
            return;
        }
        if (!this.isValidSubscription(subscriptionObject, "__getitem__", "__class_getitem__", secondaries)) {
            this.reportIssue(subscriptionExpression, subscriptionObject, "__getitem__", ctx, secondaries);
        }
    }

    private static boolean isTypeSubscription(Expression subscriptionObject) {
        return TreeUtils.getSymbolFromTree((Tree)subscriptionObject).filter(symbol -> "type".equals(symbol.fullyQualifiedName())).isPresent();
    }

    private static boolean isWithinTypeAnnotation(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.PARAMETER_TYPE_ANNOTATION, Tree.Kind.RETURN_TYPE_ANNOTATION, Tree.Kind.VARIABLE_TYPE_ANNOTATION})) != null;
    }

    private static boolean isWithinDelStatement(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.DEL_STMT}) && ((DelStatement)t).expressions().stream().anyMatch(e -> e.equals(subscriptionExpression))) != null;
    }

    private static boolean isWithinAssignment(SubscriptionExpression subscriptionExpression) {
        return TreeUtils.firstAncestor((Tree)subscriptionExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)t).lhsExpressions().stream().flatMap(lhs -> lhs.expressions().stream()).anyMatch(e -> e.equals(subscriptionExpression))) != null;
    }

    private void reportIssue(SubscriptionExpression subscriptionExpression, Expression subscriptionObject, String missingMethod, SubscriptionContext ctx, Map<LocationInFile, String> secondaries) {
        String name = TreeUtils.nameFromExpression((Expression)subscriptionObject);
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)(name != null ? subscriptionExpression : subscriptionObject), this.message(name, missingMethod));
        secondaries.keySet().stream().filter(Objects::nonNull).forEach(location -> preciseIssue.secondary(location, (String)secondaries.get(location)));
    }

    public abstract boolean isValidSubscription(Expression var1, String var2, @Nullable String var3, Map<LocationInFile, String> var4);

    public abstract String message(@Nullable String var1, String var2);
}

